/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.ART1Logic;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ART1Pattern
implements NeuralNetworkPattern {
    public static final String TAG_F1 = "F1";
    public static final String TAG_F2 = "F2";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int inputNeurons;
    private int outputNeurons;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;

    @Override
    public void addHiddenLayer(int count) {
        String str = "A ART1 network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A ART1 network has no hidden layers.");
        }
        throw new PatternError("A ART1 network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.outputNeurons = 0;
        this.inputNeurons = 0;
    }

    @Override
    public BasicNetwork generate() {
        BasicNetwork network = new BasicNetwork(new ART1Logic());
        int y = 50;
        BasicLayer layerF1 = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer layerF2 = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        WeightedSynapse synapseF1toF2 = new WeightedSynapse(layerF1, layerF2);
        WeightedSynapse synapseF2toF1 = new WeightedSynapse(layerF2, layerF1);
        layerF1.getNext().add(synapseF1toF2);
        layerF2.getNext().add(synapseF2toF1);
        network.tagLayer("INPUT", layerF1);
        network.tagLayer("OUTPUT", layerF2);
        network.tagLayer(TAG_F1, layerF1);
        network.tagLayer(TAG_F2, layerF2);
        layerF1.setX(50);
        layerF1.setY(y);
        layerF2.setX(50);
        layerF2.setY(y += 150);
        network.setProperty("A1", this.a1);
        network.setProperty("B1", this.b1);
        network.setProperty("C1", this.c1);
        network.setProperty("D1", this.d1);
        network.setProperty("L", this.l);
        network.setProperty("VIGILANCE", this.vigilance);
        network.getStructure().finalizeStructure();
        return network;
    }

    public double getA1() {
        return this.a1;
    }

    public double getB1() {
        return this.b1;
    }

    public double getC1() {
        return this.c1;
    }

    public double getD1() {
        return this.d1;
    }

    public double getL() {
        return this.l;
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public void setA1(double a1) {
        this.a1 = a1;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "Can't set the activation function for an ART1.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the activation function for an ART1.");
        }
        throw new PatternError("Can't set the activation function for an ART1.");
    }

    public void setB1(double b1) {
        this.b1 = b1;
    }

    public void setC1(double c1) {
        this.c1 = c1;
    }

    public void setD1(double d1) {
        this.d1 = d1;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    public void setL(double l) {
        this.l = l;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public void setVigilance(double vigilance) {
        this.vigilance = vigilance;
    }
}

