/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.BAMLogic;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMPattern
implements NeuralNetworkPattern {
    public static final String TAG_F1 = "F1";
    public static final String TAG_F2 = "F2";
    private int f1Neurons;
    private int f2Neurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        String str = "A BAM network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no hidden layers.");
        }
        throw new PatternError("A BAM network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.f1Neurons = 0;
        this.f2Neurons = 0;
    }

    @Override
    public BasicNetwork generate() {
        BasicNetwork network = new BasicNetwork(new BAMLogic());
        BasicLayer f1Layer = new BasicLayer(new ActivationBiPolar(), false, this.f1Neurons);
        BasicLayer f2Layer = new BasicLayer(new ActivationBiPolar(), false, this.f2Neurons);
        WeightedSynapse synapseInputToOutput = new WeightedSynapse(f1Layer, f2Layer);
        WeightedSynapse synapseOutputToInput = new WeightedSynapse(f2Layer, f1Layer);
        f1Layer.addSynapse(synapseInputToOutput);
        f2Layer.addSynapse(synapseOutputToInput);
        network.tagLayer(TAG_F1, f1Layer);
        network.tagLayer(TAG_F2, f2Layer);
        network.getStructure().finalizeStructure();
        network.getStructure().finalizeStructure();
        f1Layer.setY(50);
        f2Layer.setY(50);
        f1Layer.setX(50);
        f2Layer.setX(300);
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A BAM network can't specify a custom activation function.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network can't specify a custom activation function.");
        }
        throw new PatternError("A BAM network can't specify a custom activation function.");
    }

    public void setF1Neurons(int count) {
        this.f1Neurons = count;
    }

    public void setF2Neurons(int count) {
        this.f2Neurons = count;
    }

    @Override
    public void setInputNeurons(int count) {
        String str = "A BAM network has no input layer, consider setting F1 layer.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no input layer, consider setting F1 layer.");
        }
        throw new PatternError("A BAM network has no input layer, consider setting F1 layer.");
    }

    @Override
    public void setOutputNeurons(int count) {
        String str = "A BAM network has no output layer, consider setting F2 layer.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A BAM network has no output layer, consider setting F2 layer.");
        }
        throw new PatternError("A BAM network has no output layer, consider setting F2 layer.");
    }
}

