/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.BoltzmannLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltzmannPattern
implements NeuralNetworkPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int neuronCount;
    private int annealCycles = 100;
    private int runCycles = 1000;
    private double temperature = 0.0;

    @Override
    public void addHiddenLayer(int count) {
        String str = "A Boltzmann network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Boltzmann network has no hidden layers.");
        }
        throw new PatternError("A Boltzmann network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.neuronCount = 0;
    }

    @Override
    public BasicNetwork generate() {
        BasicLayer layer = new BasicLayer(new ActivationBiPolar(), true, this.neuronCount);
        BasicNetwork result = new BasicNetwork(new BoltzmannLogic());
        result.setProperty("ACYCLE", this.annealCycles);
        result.setProperty("RCYCLE", this.runCycles);
        result.setProperty("TEMPERATURE", this.temperature);
        result.addLayer(layer);
        layer.addNext(layer);
        layer.setX(50);
        layer.setY(50);
        result.getStructure().finalizeStructure();
        result.reset();
        return result;
    }

    public int getAnnealCycles() {
        return this.annealCycles;
    }

    public int getRunCycles() {
        return this.runCycles;
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
        }
        throw new PatternError("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    public void setAnnealCycles(int annealCycles) {
        this.annealCycles = annealCycles;
    }

    @Override
    public void setInputNeurons(int count) {
        this.neuronCount = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.neuronCount = count;
    }

    public void setRunCycles(int runCycles) {
        this.runCycles = runCycles;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

