/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationCompetitive;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPNPattern
implements NeuralNetworkPattern {
    public static final String TAG_INSTAR = "INSTAR";
    public static final String TAG_OUTSTAR = "OUTSTAR";
    private int instarCount;
    private int outstarCount;
    private int inputCount;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        String str = "A CPN already has a predefined hidden layer.  No additionalspecification is needed.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A CPN already has a predefined hidden layer.  No additionalspecification is needed.");
        }
    }

    @Override
    public void clear() {
        this.inputCount = 0;
        this.instarCount = 0;
        this.outstarCount = 0;
    }

    @Override
    public BasicNetwork generate() {
        int y = 50;
        BasicNetwork network = new BasicNetwork();
        BasicLayer input = new BasicLayer(new ActivationLinear(), false, this.inputCount);
        network.addLayer(input);
        BasicLayer instar = new BasicLayer(new ActivationCompetitive(), false, this.instarCount);
        network.addLayer(instar);
        BasicLayer outstar = new BasicLayer(new ActivationLinear(), false, this.outstarCount);
        network.addLayer(outstar);
        network.getStructure().finalizeStructure();
        network.reset();
        input.setX(50);
        input.setY(y);
        instar.setX(50);
        instar.setY(y += 150);
        outstar.setX(50);
        outstar.setY(y += 150);
        network.tagLayer("INPUT", input);
        network.tagLayer("OUTPUT", outstar);
        network.tagLayer(TAG_INSTAR, instar);
        network.tagLayer(TAG_OUTSTAR, outstar);
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.");
        }
        throw new PatternError("A CPN network will use the BiPolar & competitive activation functions, no activation function needs to be specified.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputCount = count;
    }

    public void setInstarCount(int instarCount) {
        this.instarCount = instarCount;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outstarCount = count;
    }

    public void setOutstarCount(int outstarCount) {
        this.outstarCount = outstarCount;
    }
}

