/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmanPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;
    private ActivationFunction activation;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            String str = "An Elman neural network should have only one hidden layer.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("An Elman neural network should have only one hidden layer.");
            }
            throw new PatternError("An Elman neural network should have only one hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public BasicNetwork generate() {
        int y = 50;
        ContextLayer context = new ContextLayer(this.hiddenNeurons);
        BasicNetwork network = new BasicNetwork();
        BasicLayer input = new BasicLayer(this.activation, false, this.inputNeurons);
        network.addLayer(input);
        input.setX(50);
        input.setY(y);
        BasicLayer hidden = new BasicLayer(this.activation, true, this.hiddenNeurons);
        network.addLayer(hidden);
        hidden.setX(50);
        hidden.setY(y += 150);
        context.setX(300);
        context.setY(y);
        y += 150;
        hidden.addNext(context, SynapseType.OneToOne);
        context.addNext(hidden);
        BasicLayer output = new BasicLayer(this.activation, true, this.outputNeurons);
        network.addLayer(output);
        output.setX(50);
        output.setY(y);
        network.getStructure().finalizeStructure();
        network.reset();
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.activation = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

