/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.HopfieldLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopfieldPattern
implements NeuralNetworkPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int neuronCount = -1;

    @Override
    public void addHiddenLayer(int count) {
        String str = "A Hopfield network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network has no hidden layers.");
        }
        throw new PatternError("A Hopfield network has no hidden layers.");
    }

    @Override
    public void clear() {
    }

    @Override
    public BasicNetwork generate() {
        BasicLayer layer = new BasicLayer(new ActivationBiPolar(), false, this.neuronCount);
        BasicNetwork result = new BasicNetwork(new HopfieldLogic());
        result.addLayer(layer);
        layer.addNext(layer);
        layer.setX(50);
        layer.setY(50);
        result.getStructure().finalizeStructure();
        result.reset();
        return result;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A Hopfield network will use the BiPolar activation function, no activation function needs to be specified.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network will use the BiPolar activation function, no activation function needs to be specified.");
        }
        throw new PatternError("A Hopfield network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.neuronCount = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        String str = "A Hopfield network has a single layer, so no need to specify the output count.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network has a single layer, so no need to specify the output count.");
        }
        throw new PatternError("A Hopfield network has a single layer, so no need to specify the output count.");
    }
}

