/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialBasisPattern
implements NeuralNetworkPattern {
    public static final String RBF_LAYER = "RBF";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;

    @Override
    public void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            String str = "A RBF network usually has a single hidden layer.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("A RBF network usually has a single hidden layer.");
            }
            throw new PatternError("A RBF network usually has a single hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public BasicNetwork generate() {
        BasicLayer input = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer output = new BasicLayer(new ActivationLinear(), false, this.outputNeurons);
        BasicNetwork network = new BasicNetwork();
        RadialBasisFunctionLayer rbfLayer = new RadialBasisFunctionLayer(this.hiddenNeurons);
        network.addLayer(input);
        network.addLayer(rbfLayer, SynapseType.Direct);
        network.addLayer(output);
        network.getStructure().finalizeStructure();
        network.reset();
        network.tagLayer(RBF_LAYER, rbfLayer);
        int y = 50;
        input.setX(50);
        input.setY(y);
        rbfLayer.setX(50);
        rbfLayer.setY(y += 150);
        output.setX(50);
        output.setY(y += 150);
        double volumeNeuronWidth = 2.0 / (double)rbfLayer.getNeuronCount();
        rbfLayer.setRBFCentersAndWidthsEqualSpacing(0.0, 1.0, RBFEnum.Gaussian, input.getNeuronCount(), volumeNeuronWidth, true);
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "Can't set the activation function for a radial basis function network.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't set the activation function for a radial basis function network.");
        }
        throw new PatternError("Can't set the activation function for a radial basis function network.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

