/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.svm.KernelType;
import org.encog.neural.networks.svm.SVMNetwork;
import org.encog.neural.networks.svm.SVMType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVMPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private boolean regression = true;
    private KernelType kernelType = KernelType.RadialBasisFunction;
    private SVMType svmType = SVMType.EpsilonSupportVectorRegression;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        String str = "A SVM network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SVM network has no hidden layers.");
        }
        throw new PatternError("A SVM network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    @Override
    public BasicNetwork generate() {
        SVMNetwork network = new SVMNetwork(this.inputNeurons, this.outputNeurons, this.svmType, this.kernelType);
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A SVM network can't specify a custom activation function.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A SVM network can't specify a custom activation function.");
        }
        throw new PatternError("A SVM network can't specify a custom activation function.");
    }

    public boolean isRegression() {
        return this.regression;
    }

    public void setRegression(boolean regression) {
        this.regression = regression;
    }

    public int getInputNeurons() {
        return this.inputNeurons;
    }

    public int getOutputNeurons() {
        return this.outputNeurons;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public void setKernelType(KernelType kernelType) {
        this.kernelType = kernelType;
    }

    public void setSVMType(SVMType svmType) {
        this.svmType = svmType;
    }
}

