/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.normalize.NormalizationError;
import org.encog.normalize.input.HasFixedLength;
import org.encog.normalize.input.InputField;
import org.encog.normalize.input.InputFieldCSV;
import org.encog.normalize.input.InputFieldNeuralDataSet;
import org.encog.normalize.input.NeuralDataFieldHolder;
import org.encog.normalize.output.OutputField;
import org.encog.normalize.output.OutputFieldGroup;
import org.encog.normalize.output.OutputFieldGrouped;
import org.encog.normalize.output.RequireTwoPass;
import org.encog.normalize.segregate.Segregator;
import org.encog.normalize.target.NormalizationStorage;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.obj.ReflectionUtil;

@EGReferenceable
public class DataNormalization
extends BasicPersistedObject {
    private static final long serialVersionUID = 4387885013771660300L;
    private final Collection<InputField> inputFields = new ArrayList<InputField>();
    private final Collection<OutputField> outputFields = new ArrayList<OutputField>();
    @EGIgnore
    private final Collection<ReadCSV> readCSV = new ArrayList<ReadCSV>();
    @EGIgnore
    private final Map<InputField, ReadCSV> csvMap = new HashMap<InputField, ReadCSV>();
    @EGIgnore
    private final Collection<Iterator<NeuralDataPair>> readDataSet = new ArrayList<Iterator<NeuralDataPair>>();
    @EGIgnore
    private final Map<InputField, NeuralDataFieldHolder> dataSetFieldMap = new HashMap<InputField, NeuralDataFieldHolder>();
    @EGIgnore
    private final Map<Iterator<NeuralDataPair>, NeuralDataFieldHolder> dataSetIteratorMap = new HashMap<Iterator<NeuralDataPair>, NeuralDataFieldHolder>();
    private final Set<OutputFieldGroup> groups = new HashSet<OutputFieldGroup>();
    private final Collection<Segregator> segregators = new ArrayList<Segregator>();
    private NormalizationStorage storage;
    @EGIgnore
    private StatusReportable report = new NullStatusReportable();
    private int recordCount;
    private int currentIndex;
    private CSVFormat csvFormat = CSVFormat.ENGLISH;
    private int lastReport;

    public void addInputField(InputField f) {
        this.inputFields.add(f);
    }

    public void addOutputField(OutputField outputField) {
        this.addOutputField(outputField, false);
    }

    public void addOutputField(OutputField outputField, boolean ideal) {
        this.outputFields.add(outputField);
        outputField.setIdeal(ideal);
        if (outputField instanceof OutputFieldGrouped) {
            OutputFieldGrouped ofg = (OutputFieldGrouped)outputField;
            this.groups.add(ofg.getGroup());
        }
    }

    public void addSegregator(Segregator segregator) {
        this.segregators.add(segregator);
        segregator.init(this);
    }

    private void applyMinMax() {
        for (InputField field : this.inputFields) {
            double value = field.getCurrentValue();
            field.applyMinMax(value);
        }
    }

    public NeuralData buildForNetworkInput(double[] data) {
        int index = 0;
        for (InputField field : this.inputFields) {
            if (!field.getUsedForNetworkInput()) continue;
            if (index >= data.length) {
                throw new NormalizationError("Can't build data, input fields used for neural input, must match provided data(" + data.length + ").");
            }
            field.setCurrentValue(data[index++]);
        }
        int outputCount = 0;
        for (OutputField ofield : this.outputFields) {
            if (ofield.isIdeal()) continue;
            for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                ++outputCount;
            }
        }
        this.initForOutput();
        BasicNeuralData result = new BasicNeuralData(outputCount);
        int outputIndex = 0;
        for (OutputField ofield : this.outputFields) {
            if (ofield.isIdeal()) continue;
            for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                result.setData(outputIndex++, ofield.calculate(sub));
            }
        }
        return result;
    }

    private double determineInputFieldValue(InputField field, int index) {
        double result = 0.0;
        if (field instanceof InputFieldCSV) {
            InputFieldCSV fieldCSV = (InputFieldCSV)field;
            ReadCSV csv = this.csvMap.get(field);
            result = csv.getDouble(fieldCSV.getOffset());
        } else if (field instanceof InputFieldNeuralDataSet) {
            InputFieldNeuralDataSet neuralField = (InputFieldNeuralDataSet)field;
            NeuralDataFieldHolder holder = this.dataSetFieldMap.get(field);
            NeuralDataPair pair = holder.getPair();
            int offset = neuralField.getOffset();
            result = offset < pair.getInput().size() ? pair.getInput().getData(offset) : pair.getIdeal().getData(offset -= pair.getInput().size());
        } else {
            result = field.getValue(index);
        }
        field.setCurrentValue(result);
        return result;
    }

    private void determineInputFieldValues(int index) {
        for (InputField field : this.inputFields) {
            this.determineInputFieldValue(field, index);
        }
    }

    public InputField findInputField(Class<?> clazz, int count) {
        int i = 0;
        for (InputField field : this.inputFields) {
            if (!ReflectionUtil.isInstanceOf(field.getClass(), clazz)) continue;
            if (i == count) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public OutputField findOutputField(Class<?> clazz, int count) {
        int i = 0;
        for (OutputField field : this.outputFields) {
            if (!ReflectionUtil.isInstanceOf(field.getClass(), clazz)) continue;
            if (i == count) {
                return field;
            }
            ++i;
        }
        return null;
    }

    private void firstPass() {
        this.openCSV();
        this.openDataSet();
        this.currentIndex = -1;
        this.recordCount = 0;
        this.report.report(0, 0, "Analyzing file");
        this.lastReport = 0;
        int index = 0;
        this.initForPass();
        while (this.next()) {
            this.determineInputFieldValues(index);
            if (this.shouldInclude()) {
                this.applyMinMax();
                ++this.recordCount;
                this.reportResult("First pass, analyzing file", 0, this.recordCount);
            }
            ++index;
        }
    }

    public CSVFormat getCSVFormat() {
        return this.csvFormat;
    }

    public Set<OutputFieldGroup> getGroups() {
        return this.groups;
    }

    public Collection<InputField> getInputFields() {
        return this.inputFields;
    }

    public int getNetworkInputLayerSize() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            if (field.isIdeal()) continue;
            result += field.getSubfieldCount();
        }
        return result;
    }

    public int getNetworkOutputLayerSize() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            if (!field.isIdeal()) continue;
            result += field.getSubfieldCount();
        }
        return result;
    }

    public int getOutputFieldCount() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            result += field.getSubfieldCount();
        }
        return result;
    }

    public Collection<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public StatusReportable getReport() {
        return this.report;
    }

    public Collection<Segregator> getSegregators() {
        return this.segregators;
    }

    public NormalizationStorage getStorage() {
        return this.storage;
    }

    public void initForOutput() {
        for (OutputFieldGroup group : this.groups) {
            group.rowInit();
        }
        for (OutputField field : this.outputFields) {
            field.rowInit();
        }
    }

    public void initForPass() {
        for (Segregator segregator : this.segregators) {
            segregator.passInit();
        }
    }

    private boolean next() {
        for (ReadCSV readCSV : this.readCSV) {
            if (readCSV.next()) continue;
            return false;
        }
        for (Iterator iterator : this.readDataSet) {
            if (!iterator.hasNext()) {
                return false;
            }
            NeuralDataFieldHolder holder = this.dataSetIteratorMap.get(iterator);
            NeuralDataPair pair = (NeuralDataPair)iterator.next();
            holder.setPair(pair);
        }
        for (InputField inputField : this.inputFields) {
            HasFixedLength fixed;
            if (!(inputField instanceof HasFixedLength) || this.currentIndex + 1 < (fixed = (HasFixedLength)((Object)inputField)).length()) continue;
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    private void openCSV() {
        this.csvMap.clear();
        this.readCSV.clear();
        HashMap<File, ReadCSV> uniqueFiles = new HashMap<File, ReadCSV>();
        for (InputField field : this.inputFields) {
            if (!(field instanceof InputFieldCSV)) continue;
            InputFieldCSV csvField = (InputFieldCSV)field;
            File file = csvField.getFile();
            if (!uniqueFiles.containsKey(file)) {
                ReadCSV csv = new ReadCSV(file.toString(), false, this.csvFormat);
                uniqueFiles.put(file, csv);
                this.readCSV.add(csv);
            }
            this.csvMap.put(csvField, (ReadCSV)uniqueFiles.get(file));
        }
    }

    private void openDataSet() {
        this.readDataSet.clear();
        this.dataSetFieldMap.clear();
        this.dataSetIteratorMap.clear();
        HashMap<NeuralDataSet, NeuralDataFieldHolder> uniqueSets = new HashMap<NeuralDataSet, NeuralDataFieldHolder>();
        for (InputField field : this.inputFields) {
            if (!(field instanceof InputFieldNeuralDataSet)) continue;
            InputFieldNeuralDataSet dataSetField = (InputFieldNeuralDataSet)field;
            NeuralDataSet dataSet = dataSetField.getNeuralDataSet();
            if (!uniqueSets.containsKey(dataSet)) {
                Iterator<NeuralDataPair> iterator = dataSet.iterator();
                NeuralDataFieldHolder holder = new NeuralDataFieldHolder(iterator, dataSetField);
                uniqueSets.put(dataSet, holder);
                this.readDataSet.add(iterator);
            }
            NeuralDataFieldHolder holder = (NeuralDataFieldHolder)uniqueSets.get(dataSet);
            this.dataSetFieldMap.put(dataSetField, holder);
            this.dataSetIteratorMap.put(holder.getIterator(), holder);
        }
    }

    public void process() {
        if (this.twoPassesNeeded()) {
            this.firstPass();
        }
        this.secondPass();
    }

    private void reportResult(String message, int total, int current) {
        ++this.lastReport;
        if (this.lastReport >= 10000) {
            this.report.report(total, current, message);
            this.lastReport = 0;
        }
    }

    private void secondPass() {
        boolean twopass = this.twoPassesNeeded();
        this.openCSV();
        this.openDataSet();
        this.initForPass();
        this.currentIndex = -1;
        int size = this.getOutputFieldCount();
        double[] output = new double[size];
        this.storage.open(this);
        this.lastReport = 0;
        int index = 0;
        int current = 0;
        while (this.next()) {
            for (InputField field : this.inputFields) {
                this.determineInputFieldValue(field, index);
            }
            if (this.shouldInclude()) {
                this.initForOutput();
                int outputIndex = 0;
                for (OutputField ofield : this.outputFields) {
                    for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                        output[outputIndex++] = ofield.calculate(sub);
                    }
                }
                if (twopass) {
                    this.reportResult("Second pass, normalizing data", this.recordCount, ++current);
                } else {
                    this.reportResult("Processing data (single pass)", this.recordCount, ++current);
                }
                this.storage.write(output, 0);
            }
            ++index;
        }
        this.storage.close();
    }

    public void setCSVFormat(CSVFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public void setReport(StatusReportable report) {
        this.report = report;
    }

    public void setTarget(NormalizationStorage target) {
        this.storage = target;
    }

    private boolean shouldInclude() {
        for (Segregator segregator : this.segregators) {
            if (segregator.shouldInclude()) continue;
            return false;
        }
        return true;
    }

    public boolean twoPassesNeeded() {
        for (OutputField field : this.outputFields) {
            if (!(field instanceof RequireTwoPass)) continue;
            return true;
        }
        return false;
    }
}

