/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.output.nominal;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.Equilateral;
import org.encog.normalize.input.InputField;
import org.encog.normalize.output.BasicOutputField;
import org.encog.normalize.output.nominal.NominalItem;
import org.encog.persist.annotations.EGIgnore;

public class OutputEquilateral
extends BasicOutputField {
    private final List<NominalItem> items = new ArrayList<NominalItem>();
    @EGIgnore
    private Equilateral equilateral;
    private int currentValue;
    private double high;
    private double low;

    public OutputEquilateral() {
    }

    public OutputEquilateral(double high, double low) {
        this.high = high;
        this.low = low;
    }

    public void addItem(InputField inputField, double value) {
        this.addItem(inputField, value + 0.1, value - 0.1);
    }

    public void addItem(InputField inputField, double low, double high) {
        NominalItem item = new NominalItem(inputField, low, high);
        this.items.add(item);
    }

    @Override
    public double calculate(int subfield) {
        return this.equilateral.encode(this.currentValue)[subfield];
    }

    public Equilateral getEquilateral() {
        return this.equilateral;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    @Override
    public int getSubfieldCount() {
        return this.items.size() - 1;
    }

    @Override
    public void rowInit() {
        for (int i = 0; i < this.items.size(); ++i) {
            NominalItem item = this.items.get(i);
            if (!item.isInRange()) continue;
            this.currentValue = i;
            break;
        }
        if (this.equilateral == null) {
            this.equilateral = new Equilateral(this.items.size(), this.high, this.low);
        }
    }
}

