/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.segregate;

import java.util.HashMap;
import java.util.Map;
import org.encog.normalize.DataNormalization;
import org.encog.normalize.input.InputField;
import org.encog.normalize.segregate.Segregator;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReference;

public class IntegerBalanceSegregator
implements Segregator {
    @EGReference
    private DataNormalization normalization;
    @EGReference
    private InputField target;
    private int count;
    @EGIgnore
    private final Map<Integer, Integer> runningCounts = new HashMap<Integer, Integer>();

    public IntegerBalanceSegregator(InputField target, int count) {
        this.target = target;
        this.count = count;
    }

    public IntegerBalanceSegregator() {
    }

    public String dumpCounts() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : this.runningCounts.entrySet()) {
            result.append(entry.getKey());
            result.append(" -> ");
            result.append(entry.getValue());
            result.append(" count\n");
        }
        return result.toString();
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public DataNormalization getNormalization() {
        return this.normalization;
    }

    public Map<Integer, Integer> getRunningCounts() {
        return this.runningCounts;
    }

    public InputField getTarget() {
        return this.target;
    }

    @Override
    public void init(DataNormalization normalization) {
        this.normalization = normalization;
    }

    @Override
    public void passInit() {
        this.runningCounts.clear();
    }

    @Override
    public boolean shouldInclude() {
        int key = (int)this.target.getCurrentValue();
        int value = 0;
        if (this.runningCounts.containsKey(key)) {
            value = this.runningCounts.get(key);
        }
        if (value < this.count) {
            this.runningCounts.put(key, ++value);
            return true;
        }
        return false;
    }
}

