/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.target;

import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.normalize.DataNormalization;
import org.encog.normalize.target.NormalizationStorage;
import org.encog.persist.annotations.EGIgnore;

public class NormalizationStorageNeuralDataSet
implements NormalizationStorage {
    private int inputCount;
    private int idealCount;
    @EGIgnore
    private NeuralDataSet dataset;

    public NormalizationStorageNeuralDataSet() {
    }

    public NormalizationStorageNeuralDataSet(int inputCount, int idealCount) {
        this.inputCount = inputCount;
        this.idealCount = idealCount;
        this.dataset = new BasicNeuralDataSet();
    }

    public NormalizationStorageNeuralDataSet(NeuralDataSet dataset) {
        this.dataset = dataset;
        this.inputCount = this.dataset.getInputSize();
        this.idealCount = this.dataset.getIdealSize();
    }

    @Override
    public void close() {
    }

    @Override
    public void open(DataNormalization norm) {
    }

    @Override
    public void write(double[] data, int inputCount) {
        if (this.idealCount == 0) {
            BasicNeuralData inputData = new BasicNeuralData(data);
            this.dataset.add(inputData);
        } else {
            int i;
            BasicNeuralData inputData = new BasicNeuralData(this.inputCount);
            BasicNeuralData idealData = new BasicNeuralData(this.idealCount);
            int index = 0;
            for (i = 0; i < this.inputCount; ++i) {
                inputData.setData(i, data[index++]);
            }
            for (i = 0; i < this.idealCount; ++i) {
                idealData.setData(i, data[index++]);
            }
            this.dataset.add(inputData, idealData);
        }
    }

    public NeuralDataSet getDataset() {
        return this.dataset;
    }
}

