/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.read;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.encog.parse.PeekableInputStream;
import org.encog.parse.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadTags {
    public static final int CHAR_BULLET = 149;
    public static final int CHAR_TRADEMARK = 129;
    public static final int MAX_LENGTH = 10000;
    private static Map<String, Character> charMap;
    private final PeekableInputStream source;
    private final Tag tag = new Tag();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String lockedEndTag;
    private String insertEndTag = null;

    public ReadTags(InputStream is) {
        this.source = new PeekableInputStream(is);
        if (charMap == null) {
            charMap = new HashMap<String, Character>();
            charMap.put("nbsp", Character.valueOf(' '));
            charMap.put("lt", Character.valueOf('<'));
            charMap.put("gt", Character.valueOf('>'));
            charMap.put("amp", Character.valueOf('&'));
            charMap.put("quot", Character.valueOf('\"'));
            charMap.put("bull", Character.valueOf('\u0095'));
            charMap.put("trade", Character.valueOf('\u0081'));
        }
    }

    protected void eatWhitespace() {
        while (Character.isWhitespace((char)this.source.peek())) {
            this.source.read();
        }
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean is(String name, boolean start) {
        if (!this.getTag().getName().equals(name)) {
            return false;
        }
        if (start) {
            return this.getTag().getType() == Tag.Type.BEGIN;
        }
        return this.getTag().getType() == Tag.Type.END;
    }

    protected String parseAttributeName() {
        this.eatWhitespace();
        if ("\"'".indexOf(this.source.peek()) == -1) {
            StringBuilder buffer = new StringBuilder();
            while (!Character.isWhitespace(this.source.peek()) && this.source.peek() != 61 && this.source.peek() != 62 && this.source.peek() != -1) {
                char ch = this.parseSpecialCharacter();
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return this.parseString();
    }

    private char parseSpecialCharacter() {
        char result = (char)this.source.read();
        int advanceBy = 0;
        if (result == '&') {
            int ch = 0;
            StringBuilder buffer = new StringBuilder();
            do {
                if ((ch = this.source.peek(advanceBy++)) == 38 || ch == 59 || Character.isWhitespace(ch)) continue;
                buffer.append((char)ch);
            } while (ch != 59 && ch != -1 && !Character.isWhitespace(ch));
            String b = buffer.toString().trim().toLowerCase();
            if (b.length() > 0) {
                if (b.charAt(0) == '#') {
                    try {
                        result = (char)Integer.parseInt(b.substring(1));
                    }
                    catch (NumberFormatException e) {
                        advanceBy = 0;
                    }
                } else if (charMap.containsKey(b)) {
                    result = charMap.get(b).charValue();
                } else {
                    advanceBy = 0;
                }
            } else {
                advanceBy = 0;
            }
        }
        while (advanceBy > 0) {
            this.read();
            --advanceBy;
        }
        return result;
    }

    protected String parseString() {
        StringBuilder result = new StringBuilder();
        this.eatWhitespace();
        if ("\"'".indexOf(this.source.peek()) != -1) {
            int delim = this.source.read();
            while (this.source.peek() != delim && this.source.peek() != -1 && result.length() <= 10000) {
                char ch = this.parseSpecialCharacter();
                if (ch == '\r' || ch == '\n') continue;
                result.append(ch);
            }
            if ("\"'".indexOf(this.source.peek()) != -1) {
                this.source.read();
            }
        } else {
            while (!Character.isWhitespace(this.source.peek()) && this.source.peek() != -1 && this.source.peek() != 62) {
                result.append(this.parseSpecialCharacter());
            }
        }
        return result.toString();
    }

    protected void parseTag() {
        this.tag.clear();
        this.insertEndTag = null;
        StringBuilder tagName = new StringBuilder();
        this.source.read();
        if (this.source.peek("!--")) {
            int ch;
            this.source.skip("!--".length());
            while (!this.source.peek("-->") && (ch = this.source.read()) != -1) {
                tagName.append((char)ch);
            }
            this.source.skip("-->".length());
            this.tag.setType(Tag.Type.COMMENT);
            this.tag.setName(tagName.toString());
            return;
        }
        if (this.source.peek("![CDATA[")) {
            int ch;
            this.source.skip("![CDATA[".length());
            while (!this.source.peek("]]") && (ch = this.source.read()) != -1) {
                tagName.append((char)ch);
            }
            this.source.skip("]]".length());
            this.tag.setType(Tag.Type.CDATA);
            this.tag.setName(tagName.toString());
            return;
        }
        while (!(this.source.peek() == -1 || Character.isWhitespace((char)this.source.peek()) || this.source.peek() == 62 || tagName.length() > 0 && this.source.peek() == 47)) {
            tagName.append((char)this.source.read());
        }
        this.eatWhitespace();
        if (tagName.charAt(0) == '/') {
            this.tag.setName(tagName.substring(1).toString());
            this.tag.setType(Tag.Type.END);
        } else {
            this.tag.setName(tagName.toString());
            this.tag.setType(Tag.Type.BEGIN);
        }
        while (this.source.peek() != 62 && this.source.peek() != -1) {
            String attributeName = this.parseAttributeName();
            String attributeValue = null;
            if (attributeName.equals("/")) {
                this.eatWhitespace();
                if (this.source.peek() == 62) {
                    this.insertEndTag = this.tag.getName();
                    break;
                }
            }
            this.eatWhitespace();
            if (this.source.peek() == 61) {
                this.source.read();
                attributeValue = this.parseString();
            }
            this.tag.setAttribute(attributeName, attributeValue);
        }
        this.source.read();
    }

    private boolean peekEndTag(String name) {
        int i = 0;
        while (this.source.peek(i) != -1 && Character.isWhitespace(this.source.peek(i))) {
            ++i;
        }
        if (this.source.peek(i) != 60) {
            return false;
        }
        ++i;
        while (this.source.peek(i) != -1 && Character.isWhitespace(this.source.peek(i))) {
            ++i;
        }
        if (this.source.peek(i) != 47) {
            return false;
        }
        ++i;
        while (this.source.peek(i) != -1 && Character.isWhitespace(this.source.peek(i))) {
            ++i;
        }
        for (int j = 0; j < name.length(); ++j) {
            if (Character.toLowerCase(this.source.peek(i)) != Character.toLowerCase(name.charAt(j))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int read() {
        if (this.insertEndTag != null) {
            this.tag.clear();
            this.tag.setName(this.insertEndTag);
            this.tag.setType(Tag.Type.END);
            this.insertEndTag = null;
            return 0;
        }
        if (this.lockedEndTag != null) {
            if (this.peekEndTag(this.lockedEndTag)) {
                this.lockedEndTag = null;
            } else {
                return this.source.read();
            }
        }
        if (this.source.peek() == 60) {
            this.parseTag();
            if (this.tag.getType() == Tag.Type.BEGIN && (this.tag.getName().equalsIgnoreCase("script") || this.tag.getName().equalsIgnoreCase("style"))) {
                this.lockedEndTag = this.tag.getName().toLowerCase();
            }
            return 0;
        }
        if (this.source.peek() == 38) {
            return this.parseSpecialCharacter();
        }
        return this.source.read();
    }

    public boolean readToTag() {
        int ch;
        while ((ch = this.read()) != -1) {
            if (ch != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ReadTags: currentTag=");
        if (this.tag != null) {
            result.append(this.tag.toString());
        }
        result.append("]");
        return result.toString();
    }
}

