/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.encog.persist.persistors.PersistorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistReader {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String TAG_OBJECTS = "Objects";
    private final ReadXML in;
    private final InputStream fileInput;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PersistReader(PersistenceLocation location) {
        this.fileInput = location.createInputStream();
        this.in = new ReadXML(this.fileInput);
    }

    public boolean advance(String name) {
        this.advanceObjectsCollection();
        return this.advanceObjects(name);
    }

    private boolean advanceObjects(String name) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String elementName = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (elementName != null && elementName.equals(name)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public void advanceObjectsCollection() {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN || !this.in.getTag().getName().equals(TAG_OBJECTS)) continue;
            return;
        }
        String str = "Can't find objects collection, invalid file.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Can't find objects collection, invalid file.");
        }
        throw new PersistError("Can't find objects collection, invalid file.");
    }

    private boolean advanceToTag(String tag) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            if (this.in.getTag().getName().equals(tag)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public Set<DirectoryEntry> buildDirectory() {
        TreeSet<DirectoryEntry> result = new TreeSet<DirectoryEntry>();
        this.advanceObjectsCollection();
        while (this.in.readToTag() && !this.in.is(TAG_OBJECTS, false)) {
            String type = this.in.getTag().getName();
            String name = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            String description = this.in.getTag().getAttributeValue("description");
            DirectoryEntry entry = new DirectoryEntry(type, name, description);
            result.add(entry);
            this.skipObject();
        }
        return result;
    }

    public void close() {
        try {
            this.fileInput.close();
        }
        catch (IOException e) {
            throw new PersistError(e);
        }
    }

    private void copyAttributes(WriteXML out, Map<String, String> replace) {
        for (String key : this.in.getTag().getAttributes().keySet()) {
            String value = this.in.getTag().getAttributeValue(key);
            if (replace != null && replace.containsKey(key)) {
                value = replace.get(key);
            }
            out.addAttribute(key, value);
        }
    }

    private void copyXML(WriteXML out, Map<String, String> replace) {
        int ch;
        StringBuilder text = new StringBuilder();
        int depth = 0;
        this.copyAttributes(out, replace);
        String contain = this.in.getTag().getName();
        out.beginTag(contain);
        while ((ch = this.in.read()) != -1) {
            Tag.Type type = this.in.getTag().getType();
            if (ch == 0) {
                if (type == Tag.Type.BEGIN) {
                    if (text.length() > 0) {
                        out.addText(text.toString());
                        text.setLength(0);
                    }
                    this.copyAttributes(out, null);
                    out.beginTag(this.in.getTag().getName());
                    ++depth;
                    continue;
                }
                if (type != Tag.Type.END) continue;
                if (text.length() > 0) {
                    out.addText(text.toString());
                    text.setLength(0);
                }
                if (depth == 0) break;
                out.endTag(this.in.getTag().getName());
                --depth;
                continue;
            }
            text.append((char)ch);
        }
        out.endTag(contain);
    }

    public ReadXML getXMLInput() {
        return this.in;
    }

    public Map<String, String> readHeader() {
        Map<String, String> headers = null;
        if (this.advanceToTag("Document") && this.advanceToTag("Header")) {
            headers = this.in.readPropertyBlock();
        }
        return headers;
    }

    public boolean readNextTag(String name) {
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            if (this.in.getTag().getName().equals(name)) {
                return true;
            }
            this.skipObject();
        }
        return false;
    }

    public String readNextText(String name) {
        StringBuilder result = new StringBuilder();
        return result.toString();
    }

    public EncogPersistedObject readObject(String name) {
        if (this.advance(name)) {
            String objectType = this.in.getTag().getName();
            Persistor persistor = PersistorUtil.createPersistor(objectType);
            if (persistor == null) {
                throw new PersistError("Do not know how to load: " + objectType);
            }
            return persistor.load(this.in);
        }
        return null;
    }

    public String readValue(String name) {
        StringTokenizer tok = new StringTokenizer(name, ".");
        while (tok.hasMoreTokens()) {
            String subName = tok.nextToken();
            if (this.readNextTag(subName)) continue;
            return null;
        }
        return this.readNextText(this.in.getTag().getName());
    }

    public void saveModified(WriteXML out, String targetName, String newName, String newDesc) {
        this.advanceObjectsCollection();
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String name = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (name.equals(targetName)) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put(ATTRIBUTE_NAME, newName);
                replace.put("description", newDesc);
                this.copyXML(out, replace);
                continue;
            }
            this.copyXML(out, null);
        }
    }

    public void saveTo(WriteXML out, String skip) {
        this.advanceObjectsCollection();
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            if (type != Tag.Type.BEGIN) continue;
            String name = this.in.getTag().getAttributeValue(ATTRIBUTE_NAME);
            if (name.equals(skip)) {
                this.skipObject();
                continue;
            }
            this.copyXML(out, null);
        }
    }

    private void skipObject() {
        int depth = 0;
        while (this.in.readToTag()) {
            Tag.Type type = this.in.getTag().getType();
            switch (type) {
                case END: {
                    if (depth == 0) {
                        return;
                    }
                    --depth;
                    break;
                }
                case BEGIN: {
                    ++depth;
                }
            }
        }
    }
}

