/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.OutputStream;
import java.util.Date;
import org.encog.Encog;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistWriter {
    private final WriteXML out;
    private final OutputStream fileOutput;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PersistWriter(PersistenceLocation location) {
        this.fileOutput = location.createOutputStream();
        this.out = new WriteXML(this.fileOutput);
    }

    public void begin() {
        this.out.beginDocument();
        this.out.beginTag("Document");
    }

    public void beginObjects() {
        this.out.beginTag("Objects");
    }

    public void close() {
        this.out.close();
    }

    public void end() {
        this.out.endTag();
        this.out.endDocument();
    }

    public void endObjects() {
        this.out.endTag();
    }

    public void mergeObjects(PersistenceLocation location, String skip) {
        PersistReader reader = new PersistReader(location);
        reader.saveTo(this.out, skip);
        reader.close();
    }

    public void modifyObject(PersistenceLocation location, String name, String newName, String newDesc) {
        PersistReader reader = new PersistReader(location);
        reader.saveModified(this.out, name, newName, newDesc);
        reader.close();
    }

    public void writeHeader() {
        this.out.beginTag("Header");
        this.out.addProperty("platform", "Java");
        this.out.addProperty("fileVersion", Encog.getInstance().getProperties().get("encog.file.version"));
        this.out.addProperty("encogVersion", Encog.getInstance().getProperties().get("encog.version"));
        this.out.addProperty("modified", new Date().toString());
        this.out.endTag();
    }

    public void writeObject(EncogPersistedObject obj) {
        Persistor persistor = obj.createPersistor();
        if (persistor == null) {
            String str = "Can't find a persistor for object of type " + obj.getClass().getName();
            if (this.logger.isErrorEnabled()) {
                this.logger.error(str);
            }
            throw new PersistError(str);
        }
        persistor.save(obj, this.out);
    }
}

