/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLayerPersistor
implements Persistor {
    public static final String TAG_ACTIVATION = "activation";
    public static final String PROPERTY_NEURONS = "neurons";
    public static final String PROPERTY_THRESHOLD = "threshold";
    public static final String PROPERTY_BIAS_ACTIVATION = "biasActivation";
    public static final String PROPERTY_X = "x";
    public static final String PROPERTY_Y = "y";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public EncogPersistedObject load(ReadXML in) {
        double biasActivation = 1.0;
        int neuronCount = 0;
        int x = 0;
        int y = 0;
        String threshold = null;
        ActivationFunction activation = null;
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_ACTIVATION, true)) {
                in.readToTag();
                String type = in.getTag().getName();
                activation = BasicLayerPersistor.loadActivation(type, in);
                continue;
            }
            if (in.is(PROPERTY_NEURONS, true)) {
                neuronCount = in.readIntToTag();
                continue;
            }
            if (in.is(PROPERTY_THRESHOLD, true)) {
                threshold = in.readTextToTag();
                continue;
            }
            if (in.is(PROPERTY_X, true)) {
                x = in.readIntToTag();
                continue;
            }
            if (in.is(PROPERTY_Y, true)) {
                y = in.readIntToTag();
                continue;
            }
            if (in.is(PROPERTY_BIAS_ACTIVATION, true)) {
                biasActivation = Double.parseDouble(in.readTextToTag());
                continue;
            }
            if (!in.is(end, false)) continue;
        }
        if (neuronCount > 0) {
            BasicLayer layer;
            if (threshold == null) {
                layer = new BasicLayer(activation, false, neuronCount);
            } else {
                double[] t = NumberList.fromList(CSVFormat.EG_FORMAT, threshold);
                layer = new BasicLayer(activation, true, neuronCount);
                for (int i = 0; i < t.length; ++i) {
                    layer.setBiasWeight(i, t[i]);
                }
                layer.setBiasActivation(biasActivation);
            }
            layer.setX(x);
            layer.setY(y);
            return layer;
        }
        return null;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("BasicLayer", out, obj, false);
        BasicLayer layer = (BasicLayer)obj;
        out.addProperty(PROPERTY_NEURONS, layer.getNeuronCount());
        out.addProperty(PROPERTY_X, layer.getX());
        out.addProperty(PROPERTY_Y, layer.getY());
        if (layer.hasBias()) {
            StringBuilder result = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, result, layer.getBiasWeights());
            out.addProperty(PROPERTY_THRESHOLD, result.toString());
        }
        out.addProperty(PROPERTY_BIAS_ACTIVATION, layer.getBiasActivation());
        BasicLayerPersistor.saveActivationFunction(layer.getActivationFunction(), out);
        out.endTag();
    }

    public static void saveActivationFunction(ActivationFunction activationFunction, WriteXML out) {
        if (activationFunction != null) {
            out.beginTag(TAG_ACTIVATION);
            out.beginTag(activationFunction.getClass().getSimpleName());
            String[] names = activationFunction.getParamNames();
            for (int i = 0; i < names.length; ++i) {
                String str = names[i];
                double d = activationFunction.getParams()[i];
                out.addAttribute(str, "" + CSVFormat.EG_FORMAT.format(d, 10));
            }
            out.endTag();
            out.endTag();
        }
    }

    public static ActivationFunction loadActivation(String type, ReadXML in) {
        try {
            Class<?> clazz = ReflectionUtil.resolveEncogClass(type);
            if (clazz == null) {
                throw new NeuralNetworkError("Unknown activation function type: " + type);
            }
            ActivationFunction result = (ActivationFunction)clazz.newInstance();
            block3: for (String key : in.getTag().getAttributes().keySet()) {
                int index = -1;
                for (int i = 0; i < result.getParamNames().length; ++i) {
                    if (key.equalsIgnoreCase(result.getParamNames()[i])) {
                        index = i;
                        continue block3;
                    }
                    if (index == -1) continue;
                    String str = in.getTag().getAttributeValue(key);
                    double d = CSVFormat.EG_FORMAT.parse(str);
                    result.setParam(index, d);
                }
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new EncogError(e);
        }
        catch (IllegalAccessException e) {
            throw new EncogError(e);
        }
    }
}

