/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ART1Logic;
import org.encog.neural.networks.logic.BAMLogic;
import org.encog.neural.networks.logic.BoltzmannLogic;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.logic.HopfieldLogic;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class BasicNetworkPersistor
implements Persistor {
    public static final String TAG_LAYERS = "layers";
    public static final String TAG_SYNAPSES = "synapses";
    public static final String TAG_SYNAPSE = "synapse";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_OUTPUT = "layerOutput";
    public static final String TAG_TAGS = "tags";
    public static final String TAG_TAG = "tag";
    public static final String TAG_LOGIC = "logic";
    public static final String TAG_LAYER = "layer";
    public static final String TAG_PROPERTY = "Property";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_TYPE_INPUT = "input";
    public static final String ATTRIBUTE_TYPE_OUTPUT = "output";
    public static final String ATTRIBUTE_TYPE_HIDDEN = "hidden";
    public static final String ATTRIBUTE_TYPE_BOTH = "both";
    public static final String ATTRIBUTE_TYPE_UNKNOWN = "unknown";
    public static final String ATTRIBUTE_FROM = "from";
    public static final String ATTRIBUTE_TO = "to";
    public static final String ATTRIBUTE_LAYER = "layer";
    private BasicNetwork currentNetwork;
    private final Map<Layer, Integer> layer2index = new HashMap<Layer, Integer>();
    private final Map<Integer, Layer> index2layer = new HashMap<Integer, Layer>();

    private void handleLayers(ReadXML in) {
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is("layer", true)) {
                int num = in.getTag().getAttributeInt(ATTRIBUTE_ID);
                String type = in.getTag().getAttributeValue(ATTRIBUTE_TYPE);
                in.readToTag();
                Persistor persistor = PersistorUtil.createPersistor(in.getTag().getName());
                Layer layer = (Layer)persistor.load(in);
                this.index2layer.put(num, layer);
                layer.setID(num);
                if (type != null) {
                    if (type.equals(ATTRIBUTE_TYPE_INPUT)) {
                        this.currentNetwork.tagLayer("INPUT", layer);
                    } else if (type.equals(ATTRIBUTE_TYPE_OUTPUT)) {
                        this.currentNetwork.tagLayer("OUTPUT", layer);
                    } else if (type.equals(ATTRIBUTE_TYPE_BOTH)) {
                        this.currentNetwork.tagLayer("INPUT", layer);
                        this.currentNetwork.tagLayer("OUTPUT", layer);
                    }
                }
            }
            if (!in.is(end, false)) continue;
            break;
        }
    }

    private void handleLogic(ReadXML in) {
        String value = in.readTextToTag();
        if (value.equalsIgnoreCase("ART1Logic")) {
            this.currentNetwork.setLogic(new ART1Logic());
        } else if (value.equalsIgnoreCase("BAMLogic")) {
            this.currentNetwork.setLogic(new BAMLogic());
        } else if (value.equalsIgnoreCase("BoltzmannLogic")) {
            this.currentNetwork.setLogic(new BoltzmannLogic());
        } else if (value.equalsIgnoreCase("FeedforwardLogic")) {
            this.currentNetwork.setLogic(new FeedforwardLogic());
        } else if (value.equalsIgnoreCase("HopfieldLogic")) {
            this.currentNetwork.setLogic(new HopfieldLogic());
        } else if (value.equalsIgnoreCase("SimpleRecurrentLogic")) {
            this.currentNetwork.setLogic(new SimpleRecurrentLogic());
        } else {
            try {
                NeuralLogic logic = (NeuralLogic)Class.forName(value).newInstance();
                this.currentNetwork.setLogic(logic);
            }
            catch (ClassNotFoundException e) {
                throw new EncogError(e);
            }
            catch (InstantiationException e) {
                throw new EncogError(e);
            }
            catch (IllegalAccessException e) {
                throw new EncogError(e);
            }
        }
    }

    private void handleProperties(ReadXML in) {
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_PROPERTY, true)) {
                String name = in.getTag().getAttributeValue(ATTRIBUTE_NAME);
                String value = in.readTextToTag();
                this.currentNetwork.setProperty(name, value);
            }
            if (!in.is(end, false)) continue;
            break;
        }
    }

    private void handleSynapses(ReadXML in) {
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_SYNAPSE, true)) {
                int from = in.getTag().getAttributeInt(ATTRIBUTE_FROM);
                int to = in.getTag().getAttributeInt(ATTRIBUTE_TO);
                in.readToTag();
                Persistor persistor = PersistorUtil.createPersistor(in.getTag().getName());
                Synapse synapse = (Synapse)persistor.load(in);
                synapse.setFromLayer(this.index2layer.get(from));
                synapse.setToLayer(this.index2layer.get(to));
                synapse.getFromLayer().addSynapse(synapse);
            }
            if (!in.is(end, false)) continue;
            break;
        }
    }

    private void handleTags(ReadXML in) {
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_TAG, true)) {
                String name = in.getTag().getAttributeValue(ATTRIBUTE_NAME);
                String layerStr = in.getTag().getAttributeValue("layer");
                int layerInt = Integer.parseInt(layerStr);
                Layer layer = this.index2layer.get(layerInt);
                this.currentNetwork.tagLayer(name, layer);
                in.readToTag();
            }
            if (!in.is(end, false)) continue;
            break;
        }
    }

    @Override
    public EncogPersistedObject load(ReadXML in) {
        double[] output = null;
        String name = in.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String description = in.getTag().getAttributes().get("description");
        this.currentNetwork = new BasicNetwork();
        this.currentNetwork.setName(name);
        this.currentNetwork.setDescription(description);
        while (in.readToTag()) {
            if (in.is(TAG_LAYERS, true)) {
                this.handleLayers(in);
                continue;
            }
            if (in.is(TAG_SYNAPSES, true)) {
                this.handleSynapses(in);
                continue;
            }
            if (in.is(TAG_PROPERTIES, true)) {
                this.handleProperties(in);
                continue;
            }
            if (in.is(TAG_LOGIC, true)) {
                this.handleLogic(in);
                continue;
            }
            if (in.is(TAG_TAGS, true)) {
                this.handleTags(in);
                continue;
            }
            if (in.is(TAG_OUTPUT, true)) {
                output = this.handleOutput(in);
                continue;
            }
            if (!in.is("BasicNetwork", false)) continue;
        }
        this.currentNetwork.getStructure().finalizeStructure();
        return this.currentNetwork;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("BasicNetwork", out, obj, true);
        this.currentNetwork = (BasicNetwork)obj;
        this.currentNetwork.getStructure().finalizeStructure();
        out.beginTag(TAG_LAYERS);
        this.saveLayers(out);
        out.endTag();
        out.beginTag(TAG_SYNAPSES);
        this.saveSynapses(out);
        out.endTag();
        this.saveProperties(out);
        this.saveTags(out);
        this.saveLogic(out);
        this.saveOutput(out);
        out.endTag();
    }

    private void saveLayers(WriteXML out) {
        for (Layer layer : this.currentNetwork.getStructure().getLayers()) {
            out.addAttribute(ATTRIBUTE_ID, "" + layer.getID());
            out.beginTag("layer");
            Persistor persistor = layer.createPersistor();
            persistor.save(layer, out);
            out.endTag();
            this.layer2index.put(layer, layer.getID());
        }
    }

    private void saveLogic(WriteXML out) {
        out.beginTag(TAG_LOGIC);
        NeuralLogic logic = this.currentNetwork.getLogic();
        if (logic instanceof FeedforwardLogic || logic instanceof SimpleRecurrentLogic || logic instanceof BoltzmannLogic || logic instanceof ART1Logic || logic instanceof BAMLogic || logic instanceof HopfieldLogic) {
            out.addText(logic.getClass().getSimpleName());
        } else {
            out.addText(logic.getClass().getName());
        }
        out.endTag();
    }

    private void saveProperties(WriteXML out) {
        out.beginTag(TAG_PROPERTIES);
        for (String key : this.currentNetwork.getProperties().keySet()) {
            String value = this.currentNetwork.getProperties().get(key);
            out.addAttribute(ATTRIBUTE_NAME, key);
            out.beginTag(TAG_PROPERTY);
            out.addText(value.toString());
            out.endTag();
        }
        out.endTag();
    }

    private void saveSynapses(WriteXML out) {
        for (Synapse synapse : this.currentNetwork.getStructure().getSynapses()) {
            out.addAttribute(ATTRIBUTE_FROM, "" + this.layer2index.get(synapse.getFromLayer()));
            out.addAttribute(ATTRIBUTE_TO, "" + this.layer2index.get(synapse.getToLayer()));
            out.beginTag(TAG_SYNAPSE);
            Persistor persistor = synapse.createPersistor();
            persistor.save(synapse, out);
            out.endTag();
        }
    }

    private void saveTags(WriteXML out) {
        out.beginTag(TAG_TAGS);
        for (String key : this.currentNetwork.getLayerTags().keySet()) {
            Layer value = this.currentNetwork.getLayerTags().get(key);
            out.addAttribute(ATTRIBUTE_NAME, key);
            out.addAttribute("layer", "" + this.layer2index.get(value));
            out.beginTag(TAG_TAG);
            out.endTag();
        }
        out.endTag();
    }

    private void saveOutput(WriteXML out) {
        FlatNetwork flat = this.currentNetwork.getStructure().getFlat();
        if (flat != null) {
            out.beginTag(TAG_OUTPUT);
            StringBuilder result = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, result, flat.getLayerOutput());
            out.addProperty("threshold", result.toString());
            out.endTag();
        }
    }

    private double[] handleOutput(ReadXML in) {
        String output = in.readTextToTag();
        return NumberList.fromList(CSVFormat.EG_FORMAT, output);
    }
}

