/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.io.File;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class BufferedNeuralDataSetPersistor
implements Persistor {
    public static final String TAG_FILE = "file";

    @Override
    public EncogPersistedObject load(ReadXML in) {
        String name = in.getTag().getAttributes().get("name");
        String description = in.getTag().getAttributes().get("description");
        File file = null;
        while (in.readToTag()) {
            if (in.is(TAG_FILE, true)) {
                String str = in.readTextToTag();
                file = new File(str);
                continue;
            }
            if (!in.is("BufferedNeuralDataSet", false)) continue;
        }
        BufferedNeuralDataSet binary = new BufferedNeuralDataSet(file);
        binary.setName(name);
        binary.setDescription(description);
        return binary;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        BufferedNeuralDataSet binary = (BufferedNeuralDataSet)obj;
        PersistorUtil.beginEncogObject("BufferedNeuralDataSet", out, obj, true);
        out.addProperty(TAG_FILE, binary.getFile().toString());
        out.endTag();
    }
}

