/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.script.EncogScript;

public class EncogScriptPersistor
implements Persistor {
    public static final String TAG_SOURCE = "source";
    public static final String ATTRIBUTE_LANGUAGE = "language";

    @Override
    public EncogPersistedObject load(ReadXML in) {
        String name = in.getTag().getAttributeValue("name");
        String description = in.getTag().getAttributeValue("description");
        EncogScript result = new EncogScript();
        result.setName(name);
        result.setDescription(description);
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_SOURCE, true)) {
                this.handleSource(in, result);
                continue;
            }
            if (!in.is(end, false)) continue;
            break;
        }
        return result;
    }

    private void handleSource(ReadXML in, EncogScript script) {
        String language = in.getTag().getAttributeValue(ATTRIBUTE_LANGUAGE);
        script.setLanguage(language);
        in.readToTag();
        String text = in.getTag().getName();
        script.setSource(text);
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("EncogScript", out, obj, true);
        EncogScript text = (EncogScript)obj;
        out.addAttribute(ATTRIBUTE_LANGUAGE, text.getLanguage());
        out.beginTag(TAG_SOURCE);
        out.addCDATA(text.getSource());
        out.endTag();
        out.endTag();
    }
}

