/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.ArrayList;
import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialBasisFunctionLayerPersistor
implements Persistor {
    public static final String PROPERTY_RBF = "rbf";
    public static final String PROPERTY_CENTERS = "centers";
    public static final String PROPERTY_PEAK = "peak";
    public static final String PROPERTY_WIDTH = "width";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public EncogPersistedObject load(ReadXML in) {
        int neuronCount = 0;
        int x = 0;
        int y = 0;
        boolean dimensions = true;
        RadialBasisFunction[] rbfs = new RadialBasisFunction[]{};
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is("neurons", true)) {
                neuronCount = in.readIntToTag();
                continue;
            }
            if (in.is("x", true)) {
                x = in.readIntToTag();
                continue;
            }
            if (in.is("y", true)) {
                y = in.readIntToTag();
                continue;
            }
            if (in.is(PROPERTY_RBF, true)) {
                rbfs = this.loadAllRBF(in);
                continue;
            }
            if (!in.is(end, false)) continue;
        }
        RadialBasisFunctionLayer layer = new RadialBasisFunctionLayer(neuronCount);
        layer.setRadialBasisFunction(rbfs);
        layer.setX(x);
        layer.setY(y);
        return layer;
    }

    private RadialBasisFunction[] loadAllRBF(ReadXML in) {
        ArrayList<RadialBasisFunction> rbfs = new ArrayList<RadialBasisFunction>();
        while (in.readToTag() && !in.is(PROPERTY_RBF, false)) {
            String name = in.getTag().getName();
            RadialBasisFunction rbf = this.loadRBF(name, in);
            rbfs.add(rbf);
        }
        RadialBasisFunction[] result = new RadialBasisFunction[rbfs.size()];
        for (int i = 0; i < rbfs.size(); ++i) {
            result[i] = (RadialBasisFunction)rbfs.get(i);
        }
        return result;
    }

    private RadialBasisFunction loadRBF(String name, ReadXML in) {
        RadialBasisFunction result;
        Class<?> clazz = ReflectionUtil.resolveEncogClass(name);
        if (clazz == null) {
            throw new NeuralNetworkError("Unknown activation function type: " + name);
        }
        try {
            result = (RadialBasisFunction)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PersistError(e);
        }
        catch (IllegalAccessException e) {
            throw new PersistError(e);
        }
        while (in.readToTag() && !in.is(name, false)) {
            String str;
            if (in.is(PROPERTY_CENTERS, true)) {
                str = in.readTextToTag();
                double[] centers = NumberList.fromList(CSVFormat.EG_FORMAT, str);
                result.setCenters(centers);
                continue;
            }
            if (in.is(PROPERTY_PEAK, true)) {
                str = in.readTextToTag();
                double d = Double.parseDouble(str);
                result.setPeak(d);
                continue;
            }
            if (!in.is(PROPERTY_WIDTH, true)) continue;
            str = in.readTextToTag();
            double d = Double.parseDouble(str);
            result.setWidth(d);
        }
        return result;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("RadialBasisFunctionLayer", out, obj, false);
        RadialBasisFunctionLayer layer = (RadialBasisFunctionLayer)obj;
        out.addProperty("neurons", layer.getNeuronCount());
        out.addProperty("x", layer.getX());
        out.addProperty("y", layer.getY());
        this.saveRBF(out, layer);
        out.endTag();
    }

    private void saveRBF(WriteXML out, RadialBasisFunctionLayer layer) {
        out.beginTag(PROPERTY_RBF);
        for (RadialBasisFunction rbf : layer.getRadialBasisFunction()) {
            out.beginTag(rbf.getClass().getSimpleName());
            out.addProperty(PROPERTY_CENTERS, rbf.getCenters(), rbf.getCenters().length);
            out.addProperty(PROPERTY_PEAK, rbf.getPeak());
            out.addProperty(PROPERTY_WIDTH, rbf.getWidth());
            out.endTag();
        }
        out.endTag();
    }
}

