/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class TrainingContinuationPersistor
implements Persistor {
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEM = "Item";
    public static final String ATTRIBUTE_NAME = "name";
    private TrainingContinuation current;

    public void handleItem(ReadXML in) {
        String name = in.getTag().getAttributeValue(ATTRIBUTE_NAME);
        String str = in.readTextToTag();
        double[] list = NumberList.fromList(CSVFormat.EG_FORMAT, str);
        this.current.put(name, list);
    }

    public void handleItems(ReadXML in) {
        while (in.readToTag()) {
            if (in.is(TAG_ITEM, true)) {
                this.handleItem(in);
                continue;
            }
            if (!in.is(TAG_ITEMS, false)) continue;
            break;
        }
    }

    @Override
    public EncogPersistedObject load(ReadXML in) {
        this.current = new TrainingContinuation();
        String name = in.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String description = in.getTag().getAttributes().get("description");
        this.current.setName(name);
        this.current.setDescription(description);
        while (in.readToTag()) {
            if (in.is(TAG_ITEMS, true)) {
                this.handleItems(in);
                continue;
            }
            if (!in.is("TrainingContinuation", false)) continue;
            break;
        }
        return this.current;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("TrainingContinuation", out, obj, true);
        this.current = (TrainingContinuation)obj;
        out.beginTag(TAG_ITEMS);
        this.saveItems(out);
        out.endTag();
        out.endTag();
    }

    public void saveItems(WriteXML out) {
        for (String key : this.current.getContents().keySet()) {
            out.addAttribute(ATTRIBUTE_NAME, key);
            out.beginTag(TAG_ITEM);
            double[] value = (double[])this.current.get(key);
            StringBuilder result = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, result, value);
            out.addText(result.toString());
            out.endTag();
        }
    }
}

