/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class WeightedSynapsePersistor
implements Persistor {
    public static final String TAG_WEIGHTS = "weights";

    @Override
    public EncogPersistedObject load(ReadXML in) {
        WeightedSynapse synapse = new WeightedSynapse();
        String end = in.getTag().getName();
        while (in.readToTag()) {
            if (in.is(TAG_WEIGHTS, true)) {
                in.readToTag();
                synapse.setMatrix(PersistorUtil.loadMatrix(in));
            }
            if (!in.is(end, false)) continue;
            break;
        }
        return synapse;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("WeightedSynapse", out, obj, false);
        WeightedSynapse synapse = (WeightedSynapse)obj;
        out.beginTag(TAG_WEIGHTS);
        PersistorUtil.saveMatrix(synapse.getMatrix(), out);
        out.endTag();
        out.endTag();
    }
}

