/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.util.obj.ReflectionUtil;

public class ObjectTagger {
    private final Map<Object, Integer> map = new HashMap<Object, Integer>();
    private int currentID = 1;
    private int depth;

    public void analyze(EncogPersistedObject encogObject) {
        try {
            this.depth = 0;
            this.assignObjectTag(encogObject);
            for (Field childField : ReflectionUtil.getAllFields(encogObject.getClass())) {
                if (!ReflectionUtil.shouldAccessField(childField, true)) continue;
                childField.setAccessible(true);
                Object childValue = childField.get(encogObject);
                this.tagField(childValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new PersistError(e);
        }
    }

    private void assignObjectTag(Object obj) {
        if (obj.getClass().getAnnotation(EGReferenceable.class) != null) {
            this.map.put(obj, this.currentID);
            ++this.currentID;
        }
    }

    public void clear() {
        this.map.clear();
        this.currentID = 1;
    }

    public int getReference(Object obj) {
        if (obj == null) {
            return -1;
        }
        return this.map.get(obj);
    }

    public boolean hasReference(Object obj) {
        return this.map.containsKey(obj);
    }

    private void tagCollection(Collection<?> value) throws IllegalAccessException {
        for (Object obj : value) {
            this.tagObject(obj);
        }
    }

    private void tagField(Object fieldObject) throws IllegalAccessException {
        ++this.depth;
        if (this.map.containsKey(fieldObject)) {
            return;
        }
        if (fieldObject != null) {
            if (fieldObject instanceof Collection) {
                this.tagCollection((Collection)fieldObject);
            } else {
                this.tagObject(fieldObject);
            }
        }
        --this.depth;
    }

    private void tagObject(Object parentObject) throws IllegalAccessException {
        Collection<Field> allFields = ReflectionUtil.getAllFields(parentObject.getClass());
        this.assignObjectTag(parentObject);
        for (Field childField : allFields) {
            Object childValue;
            childField.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(childField, false) || ReflectionUtil.isPrimitive(childValue = childField.get(parentObject)) || ReflectionUtil.isSimple(childValue)) continue;
            if (this.depth > 50) {
                throw new PersistError("Encog persistence is greater than 50 levels deep, closed loop likely.  Consider adding @EGReference tag near attribute: " + parentObject.getClass().toString());
            }
            if (this.map.containsKey(childValue)) continue;
            this.tagField(childValue);
        }
    }
}

