/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.crossover;

import org.encog.solve.genetic.crossover.Crossover;
import org.encog.solve.genetic.genome.Chromosome;

public class Splice
implements Crossover {
    private final int cutLength;

    public Splice(int cutLength) {
        this.cutLength = cutLength;
    }

    @Override
    public void mate(Chromosome mother, Chromosome father, Chromosome offspring1, Chromosome offspring2) {
        int i;
        int geneLength = mother.getGenes().size();
        int cutpoint1 = (int)(Math.random() * (double)(geneLength - this.cutLength));
        int cutpoint2 = cutpoint1 + this.cutLength;
        for (i = 0; i < geneLength; ++i) {
            if (i < cutpoint1 || i > cutpoint2) continue;
            offspring1.getGene(i).copy(father.getGene(i));
            offspring2.getGene(i).copy(mother.getGene(i));
        }
        for (i = 0; i < geneLength; ++i) {
            if (i >= cutpoint1 && i <= cutpoint2) continue;
            offspring1.getGene(i).copy(mother.getGene(i));
            offspring2.getGene(i).copy(father.getGene(i));
        }
    }
}

