/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.crossover;

import java.util.HashSet;
import java.util.Set;
import org.encog.solve.genetic.crossover.Crossover;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.Chromosome;

public class SpliceNoRepeat
implements Crossover {
    private final int cutLength;

    private static Gene getNotTaken(Chromosome source, Set<Gene> taken) {
        for (Gene trial : source.getGenes()) {
            if (taken.contains(trial)) continue;
            taken.add(trial);
            return trial;
        }
        return null;
    }

    public SpliceNoRepeat(int cutLength) {
        this.cutLength = cutLength;
    }

    @Override
    public void mate(Chromosome mother, Chromosome father, Chromosome offspring1, Chromosome offspring2) {
        int i;
        int geneLength = father.getGenes().size();
        int cutpoint1 = (int)(Math.random() * (double)(geneLength - this.cutLength));
        int cutpoint2 = cutpoint1 + this.cutLength;
        HashSet<Gene> taken1 = new HashSet<Gene>();
        HashSet<Gene> taken2 = new HashSet<Gene>();
        for (i = 0; i < geneLength; ++i) {
            if (i < cutpoint1 || i > cutpoint2) continue;
            offspring1.getGene(i).copy(father.getGene(i));
            offspring2.getGene(i).copy(mother.getGene(i));
            taken1.add(father.getGene(i));
            taken2.add(mother.getGene(i));
        }
        for (i = 0; i < geneLength; ++i) {
            if (i >= cutpoint1 && i <= cutpoint2) continue;
            offspring1.getGene(i).copy(SpliceNoRepeat.getNotTaken(mother, taken1));
            offspring2.getGene(i).copy(SpliceNoRepeat.getNotTaken(father, taken2));
        }
    }
}

