/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.genome;

import java.util.Comparator;
import org.encog.solve.genetic.genome.CalculateGenomeScore;
import org.encog.solve.genetic.genome.Genome;

public class GenomeComparator
implements Comparator<Genome> {
    private final CalculateGenomeScore calculateScore;

    public GenomeComparator(CalculateGenomeScore calculateScore) {
        this.calculateScore = calculateScore;
    }

    public double applyBonus(double value, double bonus) {
        double amount = value * bonus;
        if (this.calculateScore.shouldMinimize()) {
            return value - amount;
        }
        return value + amount;
    }

    public double applyPenalty(double value, double bonus) {
        double amount = value * bonus;
        if (this.calculateScore.shouldMinimize()) {
            return value - amount;
        }
        return value + amount;
    }

    public double bestScore(double d1, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return Math.min(d1, d2);
        }
        return Math.max(d1, d2);
    }

    @Override
    public int compare(Genome genome1, Genome genome2) {
        return Double.compare(genome1.getScore(), genome2.getScore());
    }

    public CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public boolean isBetterThan(double d1, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return d1 < d2;
        }
        return d1 > d2;
    }
}

