/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.species;

import java.util.ArrayList;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;

public class BasicSpecies
implements Species {
    private int age;
    private double bestScore;
    private int gensNoImprovement;
    private Genome leader;
    private final List<Genome> members = new ArrayList<Genome>();
    private double spawnsRequired;
    private long speciesID;
    @EGReference
    private Population population;

    public BasicSpecies() {
    }

    public BasicSpecies(Population population, Genome first, long speciesID) {
        this.population = population;
        this.speciesID = speciesID;
        this.bestScore = first.getScore();
        this.gensNoImprovement = 0;
        this.age = 0;
        this.leader = first;
        this.spawnsRequired = 0.0;
        this.members.add(first);
    }

    @Override
    public void calculateSpawnAmount() {
        this.spawnsRequired = 0.0;
        for (Genome genome : this.members) {
            this.spawnsRequired += genome.getAmountToSpawn();
        }
    }

    @Override
    public Genome chooseParent() {
        Genome baby;
        if (this.members.size() == 1) {
            baby = this.members.get(0);
        } else {
            int maxIndexSize = (int)(this.population.getSurvivalRate() * (double)this.members.size()) + 1;
            int theOne = (int)RangeRandomizer.randomize(0.0, maxIndexSize);
            baby = this.members.get(theOne);
        }
        return baby;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public double getBestScore() {
        return this.bestScore;
    }

    @Override
    public int getGensNoImprovement() {
        return this.gensNoImprovement;
    }

    @Override
    public Genome getLeader() {
        return this.leader;
    }

    @Override
    public List<Genome> getMembers() {
        return this.members;
    }

    @Override
    public double getNumToSpawn() {
        return this.spawnsRequired;
    }

    public Population getPopulation() {
        return this.population;
    }

    @Override
    public double getSpawnsRequired() {
        return this.spawnsRequired;
    }

    @Override
    public long getSpeciesID() {
        return this.speciesID;
    }

    @Override
    public void purge() {
        this.members.clear();
        ++this.age;
        ++this.gensNoImprovement;
        this.spawnsRequired = 0.0;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public void setBestScore(double bestScore) {
        this.bestScore = bestScore;
    }

    @Override
    public void setGensNoImprovement(int gensNoImprovement) {
        this.gensNoImprovement = gensNoImprovement;
    }

    @Override
    public void setLeader(Genome leader) {
        this.leader = leader;
    }

    @Override
    public void setSpawnsRequired(double spawnsRequired) {
        this.spawnsRequired = spawnsRequired;
    }
}

