/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.encog.EncogError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadHTML;
import org.encog.util.http.FormUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooSearch {
    private static final int MAX_TRIES = 5;
    private static final long RETRY_SLEEP = 5000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Collection<URL> doSearch(URL url) throws IOException {
        int ch;
        ArrayList<URL> result = new ArrayList<URL>();
        InputStream is = url.openStream();
        ReadHTML parse = new ReadHTML(is);
        StringBuilder buffer = new StringBuilder();
        boolean capture = false;
        while ((ch = parse.read()) != -1) {
            if (ch == 0) {
                Tag tag = parse.getTag();
                if (tag.getName().equalsIgnoreCase("url")) {
                    buffer.setLength(0);
                    capture = true;
                    continue;
                }
                if (!tag.getName().equalsIgnoreCase("/url")) continue;
                result.add(new URL(buffer.toString()));
                buffer.setLength(0);
                capture = false;
                continue;
            }
            if (!capture) continue;
            buffer.append((char)ch);
        }
        return result;
    }

    public Collection<URL> search(String searchFor) throws IOException {
        Collection<URL> result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FormUtility form = new FormUtility(bos, null);
        form.add("appid", "YahooDemo");
        form.add("results", "100");
        form.add("query", searchFor);
        form.complete();
        URL url = new URL("http://search.yahooapis.com/WebSearchService/V1/webSearch?" + bos.toString());
        bos.close();
        int tries = 0;
        boolean done = false;
        while (!done) {
            try {
                result = this.doSearch(url);
                done = true;
            }
            catch (IOException e) {
                if (tries == 5) {
                    throw e;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    throw new EncogError("Interrupted");
                }
            }
            ++tries;
        }
        return result;
    }
}

