/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.util.benchmark.RandomTrainingFactory;
import org.encog.util.simple.EncogUtility;

public final class Evaluate {
    public static final int MILIS = 1000;

    public static int evaluateTrain(int input, int hidden1, int hidden2, int output) {
        return Evaluate.evaluateTrain(null, input, hidden1, hidden2, output);
    }

    public static int evaluateTrain(EncogCLDevice device, int input, int hidden1, int hidden2, int output) {
        BasicNetwork network = EncogUtility.simpleFeedForward(input, hidden1, hidden2, output, true);
        BasicNeuralDataSet training = RandomTrainingFactory.generate(1000L, 10000, input, output, -1.0, 1.0);
        OpenCLTrainingProfile profile = null;
        if (device != null) {
            profile = new OpenCLTrainingProfile(device);
        }
        return Evaluate.evaluateTrain(profile, network, training);
    }

    public static int evaluateTrain(OpenCLTrainingProfile profile, BasicNetwork network, NeuralDataSet training) {
        ResilientPropagation train = profile == null ? new ResilientPropagation(network, training) : new ResilientPropagation(network, training, profile, 0.1, 50.0);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            train.iteration();
        }
        return iterations;
    }
}

