/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.mathutil.LinearCongruentialGenerator;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;

public final class RandomTrainingFactory {
    public static BasicNeuralDataSet generate(long seed, int count, int inputCount, int idealCount, double min, double max) {
        LinearCongruentialGenerator rand = new LinearCongruentialGenerator(seed);
        BasicNeuralDataSet result = new BasicNeuralDataSet();
        for (int i = 0; i < count; ++i) {
            BasicNeuralData inputData = new BasicNeuralData(inputCount);
            for (int j = 0; j < inputCount; ++j) {
                inputData.setData(j, rand.range(min, max));
            }
            BasicNeuralData idealData = new BasicNeuralData(idealCount);
            for (int j = 0; j < idealCount; ++j) {
                idealData.setData(j, rand.range(min, max));
            }
            BasicNeuralDataPair pair = new BasicNeuralDataPair(inputData, idealData);
            result.add(pair);
        }
        return result;
    }

    public static void generate(NeuralDataSet training, long seed, int count, double min, double max) {
        LinearCongruentialGenerator rand = new LinearCongruentialGenerator(seed);
        int inputCount = training.getInputSize();
        int idealCount = training.getIdealSize();
        for (int i = 0; i < count; ++i) {
            BasicNeuralData inputData = new BasicNeuralData(inputCount);
            for (int j = 0; j < inputCount; ++j) {
                inputData.setData(j, rand.range(min, max));
            }
            BasicNeuralData idealData = new BasicNeuralData(idealCount);
            for (int j = 0; j < idealCount; ++j) {
                idealData.setData(j, rand.range(min, max));
            }
            BasicNeuralDataPair pair = new BasicNeuralDataPair(inputData, idealData);
            training.add(pair);
        }
    }

    private RandomTrainingFactory() {
    }
}

