/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.util.csv.CSVError;
import org.encog.util.csv.CSVFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCSV {
    private final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private CSVFormat format;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BufferedReader reader;
    private final Map<String, Integer> columns = new HashMap<String, Integer>();
    private String[] data;

    public static String displayDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static Date parseDate(String when) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(when);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public ReadCSV(InputStream is, boolean headers, char delim) {
        CSVFormat format = new CSVFormat(CSVFormat.getDecimalCharacter(), delim);
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.begin(headers, format);
    }

    public ReadCSV(InputStream is, boolean headers, CSVFormat format) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.begin(headers, format);
    }

    public ReadCSV(String filename, boolean headers, char delim) {
        try {
            CSVFormat format = new CSVFormat(CSVFormat.getDecimalCharacter(), delim);
            this.reader = new BufferedReader(new FileReader(filename));
            this.begin(headers, format);
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    public ReadCSV(String filename, boolean headers, CSVFormat format) {
        try {
            this.reader = new BufferedReader(new FileReader(filename));
            this.begin(headers, format);
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    private void begin(boolean headers, CSVFormat format) {
        try {
            this.format = format;
            if (headers) {
                String line = this.reader.readLine();
                List<String> tok = this.parse(line);
                int i = 0;
                for (String header : tok) {
                    this.columns.put(header.toLowerCase(), i++);
                }
            }
            this.data = null;
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    public String get(int i) {
        return this.data[i];
    }

    public String get(String column) {
        Integer i = this.columns.get(column.toLowerCase());
        if (i == null) {
            return null;
        }
        return this.data[i];
    }

    public int getColumnCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public Date getDate(String column) {
        try {
            String str = this.get(column);
            return this.sdf.parse(str);
        }
        catch (ParseException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    public double getDouble(int index) {
        String str = this.get(index);
        return this.format.parse(str);
    }

    public double getDouble(String column) {
        String str = this.get(column);
        return this.format.parse(str);
    }

    public int getInt(String col) {
        String str = this.get(col);
        try {
            return this.format.getNumberFormatter().parse(str).intValue();
        }
        catch (ParseException e) {
            throw new CSVError(e);
        }
    }

    private void initData(String line) {
        List<String> tok = this.parse(line);
        this.data = new String[tok.size()];
    }

    public boolean next() {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                return false;
            }
            if (this.data == null) {
                this.initData(line);
            }
            List<String> tok = this.parse(line);
            int i = 0;
            for (String str : tok) {
                if (i >= this.data.length) continue;
                this.data[i++] = str;
            }
            return true;
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
    }

    private List<String> parse(String line) {
        StringBuilder item = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == this.format.getSeparator() && !quoted) {
                result.add(item.toString());
                item.setLength(0);
                quoted = false;
                continue;
            }
            if (ch == '\"' && item.length() == 0) {
                quoted = true;
                continue;
            }
            if (ch == '\"' && quoted) {
                quoted = false;
                continue;
            }
            item.append(ch);
        }
        if (item.length() > 0) {
            result.add(item.toString());
        }
        return result;
    }
}

