/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import java.io.File;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.engine.util.Format;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;
import org.encog.neural.data.csv.CSVNeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.svm.SVMNetwork;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.neural.networks.training.svm.SVMTrain;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.util.simple.TrainingDialog;

public final class EncogUtility {
    public static void convertCSV2Binary(File csvFile, File binFile, int inputCount, int outputCount, boolean headers) {
        binFile.delete();
        CSVNeuralDataSet csv = new CSVNeuralDataSet(csvFile.toString(), inputCount, outputCount, false);
        BufferedNeuralDataSet buffer = new BufferedNeuralDataSet(binFile);
        buffer.beginLoad(inputCount, outputCount);
        for (NeuralDataPair pair : csv) {
            buffer.add(pair);
        }
        buffer.endLoad();
    }

    public static void evaluate(BasicNetwork network, NeuralDataSet training) {
        for (NeuralDataPair pair : training) {
            NeuralData output = network.compute(pair.getInput());
            System.out.println("Input=" + EncogUtility.formatNeuralData(pair.getInput()) + ", Actual=" + EncogUtility.formatNeuralData(output) + ", Ideal=" + EncogUtility.formatNeuralData(pair.getIdeal()));
        }
    }

    public static String formatNeuralData(NeuralData data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(Format.formatDouble(data.getData(i), 4));
        }
        return result.toString();
    }

    public static BasicNetwork simpleFeedForward(int input, int hidden1, int hidden2, int output, boolean tanh) {
        FeedForwardPattern pattern = new FeedForwardPattern();
        pattern.setInputNeurons(input);
        pattern.setOutputNeurons(output);
        if (tanh) {
            pattern.setActivationFunction(new ActivationTANH());
        } else {
            pattern.setActivationFunction(new ActivationSigmoid());
        }
        if (hidden1 > 0) {
            pattern.addHiddenLayer(hidden1);
        }
        if (hidden2 > 0) {
            pattern.addHiddenLayer(hidden2);
        }
        BasicNetwork network = pattern.generate();
        network.reset();
        return network;
    }

    public static void trainConsole(BasicNetwork network, NeuralDataSet trainingSet, int minutes) {
        ResilientPropagation train = new ResilientPropagation(network, trainingSet);
        train.setNumThreads(0);
        EncogUtility.trainConsole(train, network, trainingSet, minutes);
    }

    public static void trainConsole(Train train, BasicNetwork network, NeuralDataSet trainingSet, int minutes) {
        long remaining;
        System.out.println("Beginning training...");
        long start = System.currentTimeMillis();
        do {
            train.iteration();
            long current = System.currentTimeMillis();
            long elapsed = (current - start) / 1000L;
            remaining = (long)minutes - elapsed / 60L;
            int iteration = train.getIteration();
            System.out.println("Iteration #" + Format.formatInteger(iteration) + " Error:" + Format.formatPercent(train.getError()) + " elapsed time = " + Format.formatTimeSpan((int)elapsed) + " time left = " + Format.formatTimeSpan((int)remaining * 60));
        } while (remaining > 0L);
        train.finishTraining();
    }

    public static void trainDialog(BasicNetwork network, NeuralDataSet trainingSet) {
        ResilientPropagation train = new ResilientPropagation(network, trainingSet);
        train.setNumThreads(0);
        EncogUtility.trainDialog(train, network, trainingSet);
    }

    public static void trainDialog(Train train, BasicNetwork network, NeuralDataSet trainingSet) {
        TrainingDialog dialog = new TrainingDialog();
        dialog.setVisible(true);
        long start = System.currentTimeMillis();
        do {
            train.iteration();
            int iteration = train.getIteration();
            long current = System.currentTimeMillis();
            long elapsed = (current - start) / 1000L;
            dialog.setIterations(iteration);
            dialog.setError(train.getError());
            dialog.setTime((int)elapsed);
        } while (!dialog.shouldStop());
        train.finishTraining();
        dialog.dispose();
    }

    public static void trainToError(BasicNetwork network, NeuralDataSet trainingSet, double error) {
        BasicTraining train = network instanceof SVMNetwork ? new SVMTrain(network, trainingSet) : new ResilientPropagation(network, trainingSet);
        EncogUtility.trainToError(train, network, trainingSet, error);
    }

    public static void trainToError(Train train, BasicNetwork network, NeuralDataSet trainingSet, double error) {
        int epoch = 1;
        System.out.println("Beginning training...");
        do {
            train.iteration();
            System.out.println("Iteration #" + Format.formatInteger(epoch) + " Error:" + Format.formatPercent(train.getError()) + " Target Error: " + Format.formatPercent(error));
            ++epoch;
        } while (train.getError() > error && !train.isTrainingDone());
        train.finishTraining();
    }

    private EncogUtility() {
    }
}

