/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ObjectPair;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class TrainingSetUtil {
    public static NeuralDataSet loadCSVTOMemory(CSVFormat format, String filename, boolean headers, int inputSize, int idealSize) {
        BasicNeuralDataSet result = new BasicNeuralDataSet();
        ReadCSV csv = new ReadCSV(filename, headers, format);
        while (csv.next()) {
            double d;
            int i;
            BasicNeuralData input = null;
            BasicNeuralData ideal = null;
            int index = 0;
            input = new BasicNeuralData(inputSize);
            for (i = 0; i < inputSize; ++i) {
                d = csv.getDouble(index++);
                input.setData(i, d);
            }
            if (inputSize > 0) {
                ideal = new BasicNeuralData(inputSize);
                for (i = 0; i < idealSize; ++i) {
                    d = csv.getDouble(index++);
                    ideal.setData(i, d);
                }
            }
            BasicNeuralDataPair pair = new BasicNeuralDataPair(input, ideal);
            result.add(pair);
        }
        return result;
    }

    public static ObjectPair<double[][], double[][]> trainingToArray(NeuralDataSet training) {
        int length = TrainingSetUtil.trainingSetSize(training);
        double[][] a = new double[length][training.getInputSize()];
        double[][] b = new double[length][training.getIdealSize()];
        int index = 0;
        for (NeuralDataPair pair : training) {
            EngineArray.arrayCopy(pair.getInputArray(), a[index]);
            EngineArray.arrayCopy(pair.getIdealArray(), b[index]);
            ++index;
        }
        return new ObjectPair<double[][], double[][]>(a, b);
    }

    public static int trainingSetSize(NeuralDataSet training) {
        if (training instanceof Indexable) {
            return (int)((Indexable)training).getRecordCount();
        }
        int length = 0;
        for (NeuralDataPair pair : training) {
            ++length;
        }
        return length;
    }
}

