/*
 * Encog(tm) Core v2.5 - Java Version
 * http://www.heatonresearch.com/encog/
 * http://code.google.com/p/encog-java/
 
 * Copyright 2008-2010 Heaton Research, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *   
 * For more information on Heaton Research copyrights, licenses 
 * and trademarks visit:
 * http://www.heatonresearch.com/copyright
 */

package org.encog.neural.pattern;

/**
 * GUI constants for creating the patterns. Specifically default x and y
 * coordinates.
 * 
 * @author jheaton
 * 
 */
public final class PatternConst {

	/**
	 * The starting x-coordinate.
	 */
	public static final int START_X = 50;

	/**
	 * The starting y-coordinate.
	 */
	public static final int START_Y = 50;

	/**
	 * How much to indent on the x-axis.
	 */
	public static final int INDENT_X = 300;

	/**
	 * How much to increase y by as the network grows.
	 */
	public static final int INC_Y = 150;

	/**
	 * Private constructor.
	 */
	private PatternConst() {

	}
}
