/*
 * Encog(tm) Core v2.5 - Java Version
 * http://www.heatonresearch.com/encog/
 * http://code.google.com/p/encog-java/
 
 * Copyright 2008-2010 Heaton Research, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *   
 * For more information on Heaton Research copyrights, licenses 
 * and trademarks visit:
 * http://www.heatonresearch.com/copyright
 */

package org.encog.script;

import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;

import org.encog.EncogError;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.EncogScriptPersistor;

/**
 * Hold one Encog script program.  Can be saved to an Encog collection.
 */
public class EncogScript extends BasicPersistedObject {

	public static final String TYPE_JAVASCRIPT = "JavaScript";
	
	private String source;
	private String language = TYPE_JAVASCRIPT;
	
	
	@Override
	public Persistor createPersistor() {
		return new EncogScriptPersistor();
	}

	/**
	 * @return the source
	 */
	public String getSource() {
		return source;
	}

	/**
	 * @param source the source to set
	 */
	public void setSource(String source) {
		this.source = source;
	}
	
	/**
	 * @return the language
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * @param language the language to set
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	public void run(ConsoleInputOutput console) {
		EncogScriptEngine engine = EncogScriptEngineFactory.getInstance().createEngine(this);
		engine.setConsole(console);
		engine.run(this);		
	}	
	
}
