/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Address {
    private final String original;
    private URL url;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Address(URL u) {
        this.url = u;
        this.original = u.toString();
    }

    public Address(URL base, String original) {
        this.original = original;
        try {
            this.url = new URL(base, original);
        }
        catch (MalformedURLException e) {
            this.logger.debug("Malformed URL", (Throwable)e);
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        if (this.url != null) {
            return this.url.toString();
        }
        return this.original;
    }
}

