/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.bot.browse.range.Link;
import org.encog.bot.dataunit.DataUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPage {
    private final List<DataUnit> data = new ArrayList<DataUnit>();
    private final List<DocumentRange> contents = new ArrayList<DocumentRange>();
    private DocumentRange title;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addContent(DocumentRange span) {
        span.setSource(this);
        this.contents.add(span);
    }

    public void addDataUnit(DataUnit unit) {
        this.data.add(unit);
    }

    public DocumentRange find(Class<?> c, int index) {
        int i = index;
        for (DocumentRange span : this.getContents()) {
            if (!span.getClass().getName().equals(c.getName())) continue;
            if (i <= 0) {
                return span;
            }
            --i;
        }
        return null;
    }

    public Link findLink(String str) {
        for (DocumentRange span : this.getContents()) {
            Link link;
            if (!(span instanceof Link) || !(link = (Link)span).getTextOnly().equals(str)) continue;
            return link;
        }
        return null;
    }

    public List<DocumentRange> getContents() {
        return this.contents;
    }

    public List<DataUnit> getData() {
        return this.data;
    }

    public int getDataSize() {
        return this.data.size();
    }

    public DataUnit getDataUnit(int i) {
        return this.data.get(i);
    }

    public DocumentRange getTitle() {
        return this.title;
    }

    public void setTitle(DocumentRange title) {
        this.title = title;
        this.title.setSource(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (DocumentRange span : this.getContents()) {
            result.append(span.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

