/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.browse.range;

import java.util.ArrayList;
import java.util.List;
import org.encog.bot.browse.WebPage;
import org.encog.bot.dataunit.DataUnit;
import org.encog.bot.dataunit.TextDataUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRange {
    private int begin;
    private int end;
    private WebPage source;
    private String idAttribute;
    private String classAttribute;
    private final List<DocumentRange> elements = new ArrayList<DocumentRange>();
    private DocumentRange parent;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DocumentRange(WebPage source) {
        this.source = source;
    }

    public void addElement(DocumentRange element) {
        this.elements.add(element);
        element.setParent(this);
    }

    public int getBegin() {
        return this.begin;
    }

    public String getClassAttribute() {
        return this.classAttribute;
    }

    public List<DocumentRange> getElements() {
        return this.elements;
    }

    public int getEnd() {
        return this.end;
    }

    public String getIdAttribute() {
        return this.idAttribute;
    }

    public DocumentRange getParent() {
        return this.parent;
    }

    public WebPage getSource() {
        return this.source;
    }

    public String getTextOnly() {
        StringBuilder result = new StringBuilder();
        for (int i = this.getBegin(); i < this.getEnd(); ++i) {
            DataUnit du = this.source.getData().get(i);
            if (!(du instanceof TextDataUnit)) continue;
            result.append(du.toString());
            result.append("\n");
        }
        return result.toString();
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setClassAttribute(String classAttribute) {
        this.classAttribute = classAttribute;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }

    public void setParent(DocumentRange parent) {
        this.parent = parent;
    }

    public void setSource(WebPage source) {
        this.source = source;
    }

    public String toString() {
        return this.getTextOnly();
    }
}

