/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.encog.bot.BotError;
import org.encog.bot.rss.RSSItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSS {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<RSSItem> items = new ArrayList<RSSItem>();

    public static String getXMLText(Node n) {
        NodeList list = n.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n2 = list.item(i);
            if (n2.getNodeType() != 3) continue;
            return n2.getNodeValue();
        }
        return null;
    }

    public static Date parseDate(String datestr) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
            Date date = formatter.parse(datestr);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<RSSItem> getItems() {
        return this.items;
    }

    public void load(URL url) {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading RSS from:" + url);
            }
            URLConnection http = url.openConnection();
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Win64; x64; Trident/4.0)");
            InputStream is = http.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document d = factory.newDocumentBuilder().parse(is);
            Element e = d.getDocumentElement();
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                String nodename = node.getNodeName();
                if (nodename.equalsIgnoreCase("channel")) {
                    this.loadChannel(node);
                    continue;
                }
                if (!nodename.equalsIgnoreCase("item")) continue;
                this.loadItem(node);
            }
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BotError(e);
        }
        catch (SAXException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BotError(e);
        }
        catch (ParserConfigurationException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BotError(e);
        }
    }

    private void loadChannel(Node channel) {
        NodeList nl = channel.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            String nodename = node.getNodeName();
            if (nodename.equalsIgnoreCase("item")) {
                this.loadItem(node);
                continue;
            }
            if (node.getNodeType() == 3) continue;
            this.attributes.put(nodename, RSS.getXMLText(node));
        }
    }

    private void loadItem(Node item) {
        RSSItem rssItem = new RSSItem();
        rssItem.load(item);
        this.items.add(rssItem);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded RSS item:" + rssItem);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        Set<String> set = this.attributes.keySet();
        for (String string : set) {
            str.append(string);
            str.append('=');
            str.append(this.attributes.get(string));
            str.append('\n');
        }
        str.append("Items:\n");
        for (RSSItem rSSItem : this.items) {
            str.append(rSSItem.toString());
            str.append('\n');
        }
        return str.toString();
    }
}

