/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.data;

import java.io.Serializable;
import org.encog.engine.data.EngineData;

public class BasicEngineData
implements EngineData,
Serializable {
    private static final long serialVersionUID = -9068229682273861359L;
    private double[] ideal;
    private double[] input;

    public static EngineData createPair(int inputSize, int idealSize) {
        BasicEngineData result = idealSize > 0 ? new BasicEngineData(new double[inputSize], new double[idealSize]) : new BasicEngineData(new double[inputSize]);
        return result;
    }

    public BasicEngineData(double[] input) {
        this.input = input;
        this.ideal = null;
    }

    public BasicEngineData(double[] input, double[] ideal) {
        this.input = input;
        this.ideal = ideal;
    }

    @Override
    public double[] getIdealArray() {
        return this.ideal;
    }

    @Override
    public double[] getInputArray() {
        return this.input;
    }

    @Override
    public boolean isSupervised() {
        return this.ideal != null;
    }

    @Override
    public void setIdealArray(double[] data) {
        this.ideal = data;
    }

    @Override
    public void setInputArray(double[] data) {
        this.input = data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[NeuralDataPair:");
        builder.append("Input:");
        builder.append(this.getInputArray());
        builder.append("Ideal:");
        builder.append(this.getIdealArray());
        builder.append("]");
        return builder.toString();
    }
}

