/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.data.BasicEngineData;
import org.encog.engine.data.EngineData;
import org.encog.engine.data.EngineIndexableSet;

public class BasicEngineDataSet
implements Serializable,
EngineIndexableSet {
    private static final long serialVersionUID = -2279722928570071183L;
    private List<EngineData> data = new ArrayList<EngineData>();

    public BasicEngineDataSet() {
    }

    public BasicEngineDataSet(double[][] input, double[][] ideal) {
        if (ideal != null) {
            for (int i = 0; i < input.length; ++i) {
                double[] inputData = input[i];
                double[] idealData = ideal[i];
                this.add(inputData, idealData);
            }
        } else {
            double[][] arr$ = input;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                double[] element;
                double[] inputData = element = arr$[i$];
                this.add(inputData);
            }
        }
    }

    public BasicEngineDataSet(List<EngineData> data) {
        this.data = data;
    }

    public void add(double[] data) {
        this.data.add(new BasicEngineData(data));
    }

    public void add(double[] inputData, double[] idealData) {
        BasicEngineData pair = new BasicEngineData(inputData, idealData);
        this.data.add(pair);
    }

    public void add(EngineData inputData) {
        this.data.add(inputData);
    }

    public List<EngineData> getData() {
        return this.data;
    }

    @Override
    public int getIdealSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        EngineData first = this.data.get(0);
        if (first.getIdealArray() == null) {
            return 0;
        }
        return first.getIdealArray().length;
    }

    @Override
    public int getInputSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        EngineData first = this.data.get(0);
        return first.getInputArray().length;
    }

    @Override
    public void getRecord(long index, EngineData pair) {
        EngineData source = this.data.get((int)index);
        pair.setInputArray(source.getInputArray());
        if (pair.getIdealArray() != null) {
            pair.setIdealArray(source.getIdealArray());
        }
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public boolean isSupervised() {
        if (this.data.size() == 0) {
            return false;
        }
        return this.data.get(0).isSupervised();
    }

    @Override
    public EngineIndexableSet openAdditional() {
        return new BasicEngineDataSet(this.data);
    }

    public void setData(List<EngineData> data) {
        this.data = data;
    }
}

