/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationGaussian
implements ActivationFunction {
    public static final int PARAM_GAUSSIAN_CENTER = 0;
    public static final int PARAM_GAUSSIAN_PEAK = 1;
    public static final int PARAM_GAUSSIAN_WIDTH = 2;
    private double[] params = new double[3];
    private static final long serialVersionUID = -7166136514935838114L;

    public ActivationGaussian(double center, double peak, double width) {
        this.params[0] = center;
        this.params[1] = peak;
        this.params[2] = width;
    }

    @Override
    public ActivationFunction clone() {
        return new ActivationGaussian(this.getCenter(), this.getPeak(), this.getWidth());
    }

    private double getWidth() {
        return this.getParams()[2];
    }

    private double getCenter() {
        return this.getParams()[0];
    }

    private double getPeak() {
        return this.getParams()[1];
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = this.params[1] * BoundMath.exp(-Math.pow(x[i] - this.params[0], 2.0) / (2.0 * this.params[2] * this.params[2]));
        }
    }

    @Override
    public double derivativeFunction(double x) {
        double width = this.params[2];
        double peak = this.params[1];
        return Math.exp(-0.5 * width * width * x * x) * peak * width * width * (width * width * x * x - 1.0);
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{"center", "peak", "width"};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

