/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationLOG
implements ActivationFunction {
    private static final long serialVersionUID = 7134233791725797522L;
    private double[] params = new double[0];

    @Override
    public ActivationFunction clone() {
        return new ActivationLOG();
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = x[i] >= 0.0 ? BoundMath.log(1.0 + x[i]) : -BoundMath.log(1.0 - x[i]);
        }
    }

    @Override
    public double derivativeFunction(double x) {
        if (x >= 0.0) {
            return 1.0 / (1.0 + x);
        }
        return 1.0 / (1.0 - x);
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

