/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationLinear
implements ActivationFunction {
    public static final int PARAM_LINEAR_SLOPE = 0;
    private static final long serialVersionUID = -5356580554235104944L;
    private double[] params = new double[1];

    public ActivationLinear() {
        this.params[0] = 1.0;
    }

    @Override
    public ActivationFunction clone() {
        return new ActivationLinear();
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    public double getSlope() {
        return this.params[0];
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = x[i] * this.params[0];
        }
    }

    @Override
    public double derivativeFunction(double d) {
        return 1.0;
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        if (derivative) {
            return "(1.0)";
        }
        return "(x)";
    }
}

