/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationSigmoid
implements ActivationFunction {
    private static final long serialVersionUID = 5622349801036468572L;
    private double[] params = new double[0];

    @Override
    public ActivationFunction clone() {
        return new ActivationSigmoid();
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = 1.0 / (1.0 + BoundMath.exp(-1.0 * x[i]));
        }
    }

    @Override
    public double derivativeFunction(double x) {
        return x * (1.0 - x);
    }

    @Override
    public String[] getParamNames() {
        String[] results = new String[]{};
        return results;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        if (derivative) {
            return "(x * (1.0f - x))";
        }
        return "(1.0f / (1.0f + exp(-1 * x)))";
    }
}

