/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationSoftMax
implements ActivationFunction {
    private static final long serialVersionUID = -960489243250457611L;
    private double[] params = new double[0];

    @Override
    public ActivationFunction clone() {
        return new ActivationSoftMax();
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        int i;
        double sum = 0.0;
        for (i = start; i < start + size; ++i) {
            x[i] = BoundMath.exp(x[i]);
            sum += x[i];
        }
        for (i = start; i < start + size; ++i) {
            x[i] = x[i] / sum;
        }
    }

    @Override
    public double derivativeFunction(double d) {
        return 1.0;
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

