/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationStep
implements ActivationFunction {
    public static final int PARAM_STEP_CENTER = 0;
    public static final int PARAM_STEP_LOW = 1;
    public static final int PARAM_STEP_HIGH = 2;
    private static final long serialVersionUID = 3416782010146745754L;
    private double[] params = new double[3];

    public ActivationStep(double low, double center, double high) {
        this.params[0] = center;
        this.params[1] = low;
        this.params[2] = high;
    }

    public ActivationStep() {
        this(0.0, 0.0, 1.0);
    }

    public double getCenter() {
        return this.params[0];
    }

    public double getLow() {
        return this.params[1];
    }

    public double getHigh() {
        return this.params[2];
    }

    @Override
    public ActivationFunction clone() {
        ActivationStep result = new ActivationStep(this.getLow(), this.getCenter(), this.getHigh());
        return result;
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    public void setCenter(double d) {
        this.setParam(0, d);
    }

    public void setHigh(double d) {
        this.setParam(2, d);
    }

    public void setLow(double d) {
        this.setParam(1, d);
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = x[i] >= this.params[0] ? this.params[2] : this.params[1];
        }
    }

    @Override
    public double derivativeFunction(double d) {
        return 1.0;
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{"center", "low", "high"};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

