/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationTANH
implements ActivationFunction {
    private static final long serialVersionUID = 9121998892720207643L;
    private double[] params = new double[0];

    @Override
    public ActivationFunction clone() {
        return new ActivationTANH();
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            x[i] = Math.tanh(x[i]);
        }
    }

    @Override
    public double derivativeFunction(double x) {
        return 1.0 - x * x;
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        if (derivative) {
            return "(1.0f - x * x)";
        }
        return "tanh(x)";
    }
}

