/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import org.encog.engine.network.activation.ActivationFunction;

public class FlatLayer {
    private final ActivationFunction activation;
    private final int count;
    private final double biasActivation;
    private FlatLayer contextFedBy;

    public FlatLayer(ActivationFunction activation, int count, double biasActivation, double[] params) {
        this.activation = activation;
        this.count = count;
        this.biasActivation = biasActivation;
        this.contextFedBy = null;
    }

    public ActivationFunction getActivation() {
        return this.activation;
    }

    public double getBiasActivation() {
        return this.biasActivation;
    }

    public int getContectCount() {
        if (this.contextFedBy == null) {
            return 0;
        }
        return this.contextFedBy.getCount();
    }

    public FlatLayer getContextFedBy() {
        return this.contextFedBy;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotalCount() {
        if (this.contextFedBy == null) {
            return this.getCount() + (this.isBias() ? 1 : 0);
        }
        return this.getCount() + (this.isBias() ? 1 : 0) + this.contextFedBy.getCount();
    }

    public boolean isBias() {
        return Math.abs(this.biasActivation) > 1.0E-6;
    }

    public void setContextFedBy(FlatLayer from) {
        this.contextFedBy = from;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[FlatLayer: count=");
        result.append(this.count);
        result.append(",bias=");
        if (this.isBias()) {
            result.append(this.biasActivation);
        } else {
            result.append("false");
        }
        if (this.contextFedBy != null) {
            result.append(",contextFed=");
            if (this.contextFedBy == this) {
                result.append("itself");
            } else {
                result.append(this.contextFedBy);
            }
        }
        result.append("]");
        return result.toString();
    }
}

