/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineDataSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkManhattan
extends TrainFlatNetworkProp {
    private final double zeroTolerance;
    private double learningRate;

    public TrainFlatNetworkManhattan(FlatNetwork network, EngineDataSet training, double learningRate) {
        super(network, training);
        this.learningRate = learningRate;
        this.zeroTolerance = 1.0E-17;
    }

    @Override
    public double updateWeight(double[] gradients, double[] lastGradient, int index) {
        if (Math.abs(gradients[index]) < this.zeroTolerance) {
            return 0.0;
        }
        if (gradients[index] > 0.0) {
            return this.learningRate;
        }
        return -this.learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }
}

